/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import net.minecraft.core.ClientAsset;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.createKey("pale");
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.createKey("spotted");
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.createKey("snowy");
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.createKey("black");
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.createKey("ashen");
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.createKey("rusty");
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.createKey("woods");
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.createKey("chestnut");
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.createKey("striped");
    public static final ResourceKey<WolfVariant> DEFAULT = PALE;

    private static ResourceKey<WolfVariant> createKey(String p_406224_) {
        return ResourceKey.create(Registries.WOLF_VARIANT, ResourceLocation.withDefaultNamespace(p_406224_));
    }

    private static void register(BootstrapContext<WolfVariant> p_406316_, ResourceKey<WolfVariant> p_406242_, String p_406301_, ResourceKey<Biome> p_406284_) {
        WolfVariants.register(p_406316_, p_406242_, p_406301_, WolfVariants.highPrioBiome(HolderSet.direct(p_406316_.lookup(Registries.BIOME).getOrThrow(p_406284_))));
    }

    private static void register(BootstrapContext<WolfVariant> p_406329_, ResourceKey<WolfVariant> p_406365_, String p_406220_, TagKey<Biome> p_406376_) {
        WolfVariants.register(p_406329_, p_406365_, p_406220_, WolfVariants.highPrioBiome(p_406329_.lookup(Registries.BIOME).getOrThrow(p_406376_)));
    }

    private static SpawnPrioritySelectors highPrioBiome(HolderSet<Biome> p_406327_) {
        return SpawnPrioritySelectors.single(new BiomeCheck(p_406327_), 1);
    }

    private static void register(BootstrapContext<WolfVariant> p_406335_, ResourceKey<WolfVariant> p_406253_, String p_406319_, SpawnPrioritySelectors p_406264_) {
        ResourceLocation $$4 = ResourceLocation.withDefaultNamespace("entity/wolf/" + p_406319_);
        ResourceLocation $$5 = ResourceLocation.withDefaultNamespace("entity/wolf/" + p_406319_ + "_tame");
        ResourceLocation $$6 = ResourceLocation.withDefaultNamespace("entity/wolf/" + p_406319_ + "_angry");
        p_406335_.register(p_406253_, new WolfVariant(new WolfVariant.AssetInfo(new ClientAsset($$4), new ClientAsset($$5), new ClientAsset($$6)), p_406264_));
    }

    public static void bootstrap(BootstrapContext<WolfVariant> p_406256_) {
        WolfVariants.register(p_406256_, PALE, "wolf", SpawnPrioritySelectors.fallback(0));
        WolfVariants.register(p_406256_, SPOTTED, "wolf_spotted", BiomeTags.IS_SAVANNA);
        WolfVariants.register(p_406256_, SNOWY, "wolf_snowy", Biomes.GROVE);
        WolfVariants.register(p_406256_, BLACK, "wolf_black", Biomes.OLD_GROWTH_PINE_TAIGA);
        WolfVariants.register(p_406256_, ASHEN, "wolf_ashen", Biomes.SNOWY_TAIGA);
        WolfVariants.register(p_406256_, RUSTY, "wolf_rusty", BiomeTags.IS_JUNGLE);
        WolfVariants.register(p_406256_, WOODS, "wolf_woods", Biomes.FOREST);
        WolfVariants.register(p_406256_, CHESTNUT, "wolf_chestnut", Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        WolfVariants.register(p_406256_, STRIPED, "wolf_striped", BiomeTags.IS_BADLANDS);
    }
}

