/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class ChickenVariants {
    public static final ResourceKey<ChickenVariant> TEMPERATE = ChickenVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<ChickenVariant> WARM = ChickenVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<ChickenVariant> COLD = ChickenVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<ChickenVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<ChickenVariant> createKey(ResourceLocation p_401837_) {
        return ResourceKey.create(Registries.CHICKEN_VARIANT, p_401837_);
    }

    public static void bootstrap(BootstrapContext<ChickenVariant> p_401788_) {
        ChickenVariants.register(p_401788_, TEMPERATE, ChickenVariant.ModelType.NORMAL, "temperate_chicken", SpawnPrioritySelectors.fallback(0));
        ChickenVariants.register(p_401788_, WARM, ChickenVariant.ModelType.NORMAL, "warm_chicken", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        ChickenVariants.register(p_401788_, COLD, ChickenVariant.ModelType.COLD, "cold_chicken", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<ChickenVariant> p_401876_, ResourceKey<ChickenVariant> p_401759_, ChickenVariant.ModelType p_401874_, String p_401848_, TagKey<Biome> p_401855_) {
        HolderSet.Named<Biome> $$5 = p_401876_.lookup(Registries.BIOME).getOrThrow(p_401855_);
        ChickenVariants.register(p_401876_, p_401759_, p_401874_, p_401848_, SpawnPrioritySelectors.single(new BiomeCheck($$5), 1));
    }

    private static void register(BootstrapContext<ChickenVariant> p_401849_, ResourceKey<ChickenVariant> p_401916_, ChickenVariant.ModelType p_401822_, String p_401905_, SpawnPrioritySelectors p_401817_) {
        ResourceLocation $$5 = ResourceLocation.withDefaultNamespace("entity/chicken/" + p_401905_);
        p_401849_.register(p_401916_, new ChickenVariant(new ModelAndTexture<ChickenVariant.ModelType>(p_401822_, $$5), p_401817_));
    }
}

