/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class RandomPos {
    private static final int RANDOM_POS_ATTEMPTS = 10;

    public static BlockPos generateRandomDirection(RandomSource p_217852_, int p_217853_, int p_217854_) {
        int $$3 = p_217852_.nextInt(2 * p_217853_ + 1) - p_217853_;
        int $$4 = p_217852_.nextInt(2 * p_217854_ + 1) - p_217854_;
        int $$5 = p_217852_.nextInt(2 * p_217853_ + 1) - p_217853_;
        return new BlockPos($$3, $$4, $$5);
    }

    @Nullable
    public static BlockPos generateRandomDirectionWithinRadians(RandomSource p_217856_, int p_217857_, int p_217858_, int p_217859_, double p_217860_, double p_217861_, double p_217862_) {
        double $$7 = Mth.atan2(p_217861_, p_217860_) - 1.5707963705062866;
        double $$8 = $$7 + (double)(2.0f * p_217856_.nextFloat() - 1.0f) * p_217862_;
        double $$9 = Math.sqrt(p_217856_.nextDouble()) * (double)Mth.SQRT_OF_TWO * (double)p_217857_;
        double $$10 = -$$9 * Math.sin($$8);
        double $$11 = $$9 * Math.cos($$8);
        if (Math.abs($$10) > (double)p_217857_ || Math.abs($$11) > (double)p_217857_) {
            return null;
        }
        int $$12 = p_217856_.nextInt(2 * p_217858_ + 1) - p_217858_ + p_217859_;
        return BlockPos.containing($$10, $$12, $$11);
    }

    @VisibleForTesting
    public static BlockPos moveUpOutOfSolid(BlockPos p_148546_, int p_148547_, Predicate<BlockPos> p_148548_) {
        if (p_148548_.test(p_148546_)) {
            BlockPos.MutableBlockPos $$3 = p_148546_.mutable().move(Direction.UP);
            while ($$3.getY() <= p_148547_ && p_148548_.test($$3)) {
                $$3.move(Direction.UP);
            }
            return $$3.immutable();
        }
        return p_148546_;
    }

    @VisibleForTesting
    public static BlockPos moveUpToAboveSolid(BlockPos p_26948_, int p_26949_, int p_26950_, Predicate<BlockPos> p_26951_) {
        if (p_26949_ < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + p_26949_ + ", expected >= 0");
        }
        if (p_26951_.test(p_26948_)) {
            BlockPos.MutableBlockPos $$4 = p_26948_.mutable().move(Direction.UP);
            while ($$4.getY() <= p_26950_ && p_26951_.test($$4)) {
                $$4.move(Direction.UP);
            }
            int $$5 = $$4.getY();
            while ($$4.getY() <= p_26950_ && $$4.getY() - $$5 < p_26949_) {
                $$4.move(Direction.UP);
                if (!p_26951_.test($$4)) continue;
                $$4.move(Direction.DOWN);
                break;
            }
            return $$4.immutable();
        }
        return p_26948_;
    }

    @Nullable
    public static Vec3 generateRandomPos(PathfinderMob p_148543_, Supplier<BlockPos> p_148544_) {
        return RandomPos.generateRandomPos(p_148544_, p_148543_::getWalkTargetValue);
    }

    @Nullable
    public static Vec3 generateRandomPos(Supplier<BlockPos> p_148562_, ToDoubleFunction<BlockPos> p_148563_) {
        double $$2 = Double.NEGATIVE_INFINITY;
        BlockPos $$3 = null;
        for (int $$4 = 0; $$4 < 10; ++$$4) {
            double $$6;
            BlockPos $$5 = p_148562_.get();
            if ($$5 == null || !(($$6 = p_148563_.applyAsDouble($$5)) > $$2)) continue;
            $$2 = $$6;
            $$3 = $$5;
        }
        return $$3 != null ? Vec3.atBottomCenterOf($$3) : null;
    }

    public static BlockPos generateRandomPosTowardDirection(PathfinderMob p_217864_, int p_217865_, RandomSource p_217866_, BlockPos p_217867_) {
        int $$4 = p_217867_.getX();
        int $$5 = p_217867_.getZ();
        if (p_217864_.hasHome() && p_217865_ > 1) {
            BlockPos $$6 = p_217864_.getHomePosition();
            $$4 = p_217864_.getX() > (double)$$6.getX() ? ($$4 -= p_217866_.nextInt(p_217865_ / 2)) : ($$4 += p_217866_.nextInt(p_217865_ / 2));
            $$5 = p_217864_.getZ() > (double)$$6.getZ() ? ($$5 -= p_217866_.nextInt(p_217865_ / 2)) : ($$5 += p_217866_.nextInt(p_217865_ / 2));
        }
        return BlockPos.containing((double)$$4 + p_217864_.getX(), (double)p_217867_.getY() + p_217864_.getY(), (double)$$5 + p_217864_.getZ());
    }
}

