/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.item.ItemEntity;

public class NearestItemSensor
extends Sensor<Mob> {
    private static final long XZ_RANGE = 32L;
    private static final long Y_RANGE = 16L;
    public static final int MAX_DISTANCE_TO_WANTED_ITEM = 32;

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
    }

    @Override
    protected void doTick(ServerLevel p_26697_, Mob p_26698_) {
        Brain<?> $$2 = p_26698_.getBrain();
        List<ItemEntity> $$3 = p_26697_.getEntitiesOfClass(ItemEntity.class, p_26698_.getBoundingBox().inflate(32.0, 16.0, 32.0), p_26703_ -> true);
        $$3.sort(Comparator.comparingDouble(p_26698_::distanceToSqr));
        Optional<ItemEntity> $$4 = $$3.stream().filter(p_375745_ -> p_26698_.wantsToPickUp(p_26697_, p_375745_.getItem())).filter(p_26701_ -> p_26701_.closerThan(p_26698_, 32.0)).filter(p_26698_::hasLineOfSight).findFirst();
        $$2.setMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, $$4);
    }
}

