/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ValidateNearbyPoi {
    private static final int MAX_DISTANCE = 16;

    public static BehaviorControl<LivingEntity> create(Predicate<Holder<PoiType>> p_259460_, MemoryModuleType<GlobalPos> p_259635_) {
        return BehaviorBuilder.create(p_259215_ -> p_259215_.group(p_259215_.present(p_259635_)).apply((Applicative)p_259215_, p_259498_ -> (p_390586_, p_390587_, p_390588_) -> {
            GlobalPos $$6 = (GlobalPos)p_259215_.get(p_259498_);
            BlockPos $$7 = $$6.pos();
            if (p_390586_.dimension() != $$6.dimension() || !$$7.closerToCenterThan(p_390587_.position(), 16.0)) {
                return false;
            }
            ServerLevel $$8 = p_390586_.getServer().getLevel($$6.dimension());
            if ($$8 == null || !$$8.getPoiManager().exists($$7, p_259460_)) {
                p_259498_.erase();
            } else if (ValidateNearbyPoi.bedIsOccupied($$8, $$7, p_390587_)) {
                p_259498_.erase();
                if (!ValidateNearbyPoi.bedIsOccupiedByVillager($$8, $$7)) {
                    p_390586_.getPoiManager().release($$7);
                    DebugPackets.sendPoiTicketCountPacket(p_390586_, $$7);
                }
            }
            return true;
        }));
    }

    private static boolean bedIsOccupied(ServerLevel p_24531_, BlockPos p_24532_, LivingEntity p_24533_) {
        BlockState $$3 = p_24531_.getBlockState(p_24532_);
        return $$3.is(BlockTags.BEDS) && $$3.getValue(BedBlock.OCCUPIED) != false && !p_24533_.isSleeping();
    }

    private static boolean bedIsOccupiedByVillager(ServerLevel p_390597_, BlockPos p_390596_) {
        List<Villager> $$2 = p_390597_.getEntitiesOfClass(Villager.class, new AABB(p_390596_), LivingEntity::isSleeping);
        return !$$2.isEmpty();
    }
}

