/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;

public class AnimalMakeLove
extends Behavior<Animal> {
    private static final int BREED_RANGE = 3;
    private static final int MIN_DURATION = 60;
    private static final int MAX_DURATION = 110;
    private final EntityType<? extends Animal> partnerType;
    private final float speedModifier;
    private final int closeEnoughDistance;
    private static final int DEFAULT_CLOSE_ENOUGH_DISTANCE = 2;
    private long spawnChildAtTime;

    public AnimalMakeLove(EntityType<? extends Animal> p_320473_) {
        this(p_320473_, 1.0f, 2);
    }

    public AnimalMakeLove(EntityType<? extends Animal> p_22391_, float p_22392_, int p_320576_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 110);
        this.partnerType = p_22391_;
        this.speedModifier = p_22392_;
        this.closeEnoughDistance = p_320576_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_22401_, Animal p_22402_) {
        return p_22402_.isInLove() && this.findValidBreedPartner(p_22402_).isPresent();
    }

    @Override
    protected void start(ServerLevel p_22404_, Animal p_22405_, long p_22406_) {
        Animal $$3 = this.findValidBreedPartner(p_22405_).get();
        p_22405_.getBrain().setMemory(MemoryModuleType.BREED_TARGET, $$3);
        $$3.getBrain().setMemory(MemoryModuleType.BREED_TARGET, p_22405_);
        BehaviorUtils.lockGazeAndWalkToEachOther(p_22405_, $$3, this.speedModifier, this.closeEnoughDistance);
        int $$4 = 60 + p_22405_.getRandom().nextInt(50);
        this.spawnChildAtTime = p_22406_ + (long)$$4;
    }

    @Override
    protected boolean canStillUse(ServerLevel p_22416_, Animal p_22417_, long p_22418_) {
        if (!this.hasBreedTargetOfRightType(p_22417_)) {
            return false;
        }
        Animal $$3 = this.getBreedTarget(p_22417_);
        return $$3.isAlive() && p_22417_.canMate($$3) && BehaviorUtils.entityIsVisible(p_22417_.getBrain(), $$3) && p_22418_ <= this.spawnChildAtTime && !p_22417_.isPanicking() && !$$3.isPanicking();
    }

    @Override
    protected void tick(ServerLevel p_22428_, Animal p_22429_, long p_22430_) {
        Animal $$3 = this.getBreedTarget(p_22429_);
        BehaviorUtils.lockGazeAndWalkToEachOther(p_22429_, $$3, this.speedModifier, this.closeEnoughDistance);
        if (!p_22429_.closerThan($$3, 3.0)) {
            return;
        }
        if (p_22430_ >= this.spawnChildAtTime) {
            p_22429_.spawnChildFromBreeding(p_22428_, $$3);
            p_22429_.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
            $$3.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        }
    }

    @Override
    protected void stop(ServerLevel p_22438_, Animal p_22439_, long p_22440_) {
        p_22439_.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        p_22439_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_22439_.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.spawnChildAtTime = 0L;
    }

    private Animal getBreedTarget(Animal p_22410_) {
        return (Animal)p_22410_.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
    }

    private boolean hasBreedTargetOfRightType(Animal p_22422_) {
        Brain<AgeableMob> $$1 = p_22422_.getBrain();
        return $$1.hasMemoryValue(MemoryModuleType.BREED_TARGET) && $$1.getMemory(MemoryModuleType.BREED_TARGET).get().getType() == this.partnerType;
    }

    private Optional<? extends Animal> findValidBreedPartner(Animal p_22432_) {
        return p_22432_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().findClosest(p_426985_ -> {
            Animal $$2;
            return p_426985_.getType() == this.partnerType && p_426985_ instanceof Animal && p_22432_.canMate($$2 = (Animal)p_426985_) && !$$2.isPanicking();
        }).map(Animal.class::cast);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (Animal)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Animal)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Animal)livingEntity, l);
    }
}

