/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.scores.PlayerTeam;

public abstract class TamableAnimal
extends Animal
implements OwnableEntity {
    public static final int TELEPORT_WHEN_DISTANCE_IS_SQ = 144;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 1;
    private static final boolean DEFAULT_ORDERED_TO_SIT = false;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(TamableAnimal.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(TamableAnimal.class, EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private boolean orderedToSit = false;

    protected TamableAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super((EntityType<? extends Animal>)p_21803_, p_21804_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326034_) {
        super.defineSynchedData(p_326034_);
        p_326034_.define(DATA_FLAGS_ID, (byte)0);
        p_326034_.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422556_) {
        super.addAdditionalSaveData(p_422556_);
        EntityReference<LivingEntity> $$1 = this.getOwnerReference();
        EntityReference.store($$1, p_422556_, "Owner");
        p_422556_.putBoolean("Sitting", this.orderedToSit);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421492_) {
        super.readAdditionalSaveData(p_421492_);
        EntityReference $$1 = EntityReference.readWithOldOwnerConversion(p_421492_, "Owner", this.level());
        if ($$1 != null) {
            try {
                this.entityData.set(DATA_OWNERUUID_ID, Optional.of($$1));
                this.setTame(true, false);
            }
            catch (Throwable $$2) {
                this.setTame(false, true);
            }
        } else {
            this.entityData.set(DATA_OWNERUUID_ID, Optional.empty());
            this.setTame(false, true);
        }
        this.orderedToSit = p_421492_.getBooleanOr("Sitting", false);
        this.setInSittingPose(this.orderedToSit);
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    protected void spawnTamingParticles(boolean p_21835_) {
        SimpleParticleType $$1 = ParticleTypes.HEART;
        if (!p_21835_) {
            $$1 = ParticleTypes.SMOKE;
        }
        for (int $$2 = 0; $$2 < 7; ++$$2) {
            double $$3 = this.random.nextGaussian() * 0.02;
            double $$4 = this.random.nextGaussian() * 0.02;
            double $$5 = this.random.nextGaussian() * 0.02;
            this.level().addParticle($$1, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), $$3, $$4, $$5);
        }
    }

    @Override
    public void handleEntityEvent(byte p_21807_) {
        if (p_21807_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_21807_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(p_21807_);
        }
    }

    public boolean isTame() {
        return (this.entityData.get(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean p_21836_, boolean p_326134_) {
        byte $$2 = this.entityData.get(DATA_FLAGS_ID);
        if (p_21836_) {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$2 | 4));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$2 & 0xFFFFFFFB));
        }
        if (p_326134_) {
            this.applyTamingSideEffects();
        }
    }

    protected void applyTamingSideEffects() {
    }

    public boolean isInSittingPose() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean p_21838_) {
        byte $$1 = this.entityData.get(DATA_FLAGS_ID);
        if (p_21838_) {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$1 | 1));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$1 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return this.entityData.get(DATA_OWNERUUID_ID).orElse(null);
    }

    public void setOwner(@Nullable LivingEntity p_394333_) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(p_394333_).map(EntityReference::new));
    }

    public void setOwnerReference(@Nullable EntityReference<LivingEntity> p_393498_) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(p_393498_));
    }

    public void tame(Player p_21829_) {
        this.setTame(true, true);
        this.setOwner(p_21829_);
        if (p_21829_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_21829_;
            CriteriaTriggers.TAME_ANIMAL.trigger($$1, this);
        }
    }

    @Override
    public boolean canAttack(LivingEntity p_21822_) {
        if (this.isOwnedBy(p_21822_)) {
            return false;
        }
        return super.canAttack(p_21822_);
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.getOwner();
    }

    public boolean wantsToAttack(LivingEntity p_21810_, LivingEntity p_21811_) {
        return true;
    }

    @Override
    @Nullable
    public PlayerTeam getTeam() {
        LivingEntity $$1;
        PlayerTeam $$0 = super.getTeam();
        if ($$0 != null) {
            return $$0;
        }
        if (this.isTame() && ($$1 = this.getRootOwner()) != null) {
            return $$1.getTeam();
        }
        return null;
    }

    @Override
    protected boolean considersEntityAsAlly(Entity p_362625_) {
        if (this.isTame()) {
            LivingEntity $$1 = this.getRootOwner();
            if (p_362625_ == $$1) {
                return true;
            }
            if ($$1 != null) {
                return $$1.considersEntityAsAlly(p_362625_);
            }
        }
        return super.considersEntityAsAlly(p_362625_);
    }

    @Override
    public void die(DamageSource p_21809_) {
        LivingEntity livingEntity;
        ServerLevel $$1;
        Level level = this.level();
        if (level instanceof ServerLevel && ($$1 = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && (livingEntity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$2 = (ServerPlayer)livingEntity;
            $$2.sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(p_21809_);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean p_21840_) {
        this.orderedToSit = p_21840_;
    }

    public void tryToTeleportToOwner() {
        LivingEntity $$0 = this.getOwner();
        if ($$0 != null) {
            this.teleportToAroundBlockPos($$0.blockPosition());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity $$0 = this.getOwner();
        return $$0 != null && this.distanceToSqr(this.getOwner()) >= 144.0;
    }

    private void teleportToAroundBlockPos(BlockPos p_350657_) {
        for (int $$1 = 0; $$1 < 10; ++$$1) {
            int $$2 = this.random.nextIntBetweenInclusive(-3, 3);
            int $$3 = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs($$2) < 2 && Math.abs($$3) < 2) continue;
            int $$4 = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(p_350657_.getX() + $$2, p_350657_.getY() + $$4, p_350657_.getZ() + $$3)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_350930_, int p_350303_, int p_350410_) {
        if (!this.canTeleportTo(new BlockPos(p_350930_, p_350303_, p_350410_))) {
            return false;
        }
        this.snapTo((double)p_350930_ + 0.5, p_350303_, (double)p_350410_ + 0.5, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos p_350767_) {
        PathType $$1 = WalkNodeEvaluator.getPathTypeStatic(this, p_350767_);
        if ($$1 != PathType.WALKABLE) {
            return false;
        }
        BlockState $$2 = this.level().getBlockState(p_350767_.below());
        if (!this.canFlyToOwner() && $$2.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos $$3 = p_350767_.subtract(this.blockPosition());
        return this.level().noCollision(this, this.getBoundingBox().move($$3));
    }

    public final boolean unableToMoveToOwner() {
        return this.isOrderedToSit() || this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public class TamableAnimalPanicGoal
    extends PanicGoal {
        public TamableAnimalPanicGoal(double p_350422_, TagKey<DamageType> p_350418_) {
            super((PathfinderMob)TamableAnimal.this, p_350422_, p_350418_);
        }

        public TamableAnimalPanicGoal(double p_350932_) {
            super(TamableAnimal.this, p_350932_);
        }

        @Override
        public void tick() {
            if (!TamableAnimal.this.unableToMoveToOwner() && TamableAnimal.this.shouldTryTeleportToOwner()) {
                TamableAnimal.this.tryToTeleportToOwner();
            }
            super.tick();
        }
    }
}

