/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntityEquipment {
    public static final Codec<EntityEquipment> CODEC = Codec.unboundedMap(EquipmentSlot.CODEC, ItemStack.CODEC).xmap(p_398046_ -> {
        EnumMap<EquipmentSlot, ItemStack> $$1 = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        $$1.putAll((Map<EquipmentSlot, ItemStack>)p_398046_);
        return new EntityEquipment($$1);
    }, p_397308_ -> {
        EnumMap<EquipmentSlot, ItemStack> $$1 = new EnumMap<EquipmentSlot, ItemStack>(p_397308_.items);
        $$1.values().removeIf(ItemStack::isEmpty);
        return $$1;
    });
    private final EnumMap<EquipmentSlot, ItemStack> items;

    private EntityEquipment(EnumMap<EquipmentSlot, ItemStack> p_397767_) {
        this.items = p_397767_;
    }

    public EntityEquipment() {
        this(new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class));
    }

    public ItemStack set(EquipmentSlot p_397821_, ItemStack p_397647_) {
        p_397647_.getItem().verifyComponentsAfterLoad(p_397647_);
        return Objects.requireNonNullElse(this.items.put(p_397821_, p_397647_), ItemStack.EMPTY);
    }

    public ItemStack get(EquipmentSlot p_397366_) {
        return this.items.getOrDefault(p_397366_, ItemStack.EMPTY);
    }

    public boolean isEmpty() {
        for (ItemStack $$0 : this.items.values()) {
            if ($$0.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void tick(Entity p_401779_) {
        for (Map.Entry<EquipmentSlot, ItemStack> $$1 : this.items.entrySet()) {
            ItemStack $$2 = $$1.getValue();
            if ($$2.isEmpty()) continue;
            $$2.inventoryTick(p_401779_.level(), p_401779_, $$1.getKey());
        }
    }

    public void setAll(EntityEquipment p_401921_) {
        this.items.clear();
        this.items.putAll(p_401921_.items);
    }

    public void dropAll(LivingEntity p_401845_) {
        for (ItemStack $$1 : this.items.values()) {
            p_401845_.drop($$1, true, false);
        }
        this.clear();
    }

    public void clear() {
        this.items.replaceAll((p_401733_, p_401734_) -> ItemStack.EMPTY);
    }
}

