/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;

public class AnimationState {
    private static final int STOPPED = Integer.MIN_VALUE;
    private int startTick = Integer.MIN_VALUE;

    public void start(int p_216978_) {
        this.startTick = p_216978_;
    }

    public void startIfStopped(int p_216983_) {
        if (!this.isStarted()) {
            this.start(p_216983_);
        }
    }

    public void animateWhen(boolean p_252220_, int p_249486_) {
        if (p_252220_) {
            this.startIfStopped(p_249486_);
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.startTick = Integer.MIN_VALUE;
    }

    public void ifStarted(Consumer<AnimationState> p_216980_) {
        if (this.isStarted()) {
            p_216980_.accept(this);
        }
    }

    public void fastForward(int p_326400_, float p_325947_) {
        if (!this.isStarted()) {
            return;
        }
        this.startTick -= (int)((float)p_326400_ * p_325947_);
    }

    public long getTimeInMillis(float p_365040_) {
        float $$1 = p_365040_ - (float)this.startTick;
        return (long)($$1 * 50.0f);
    }

    public boolean isStarted() {
        return this.startTick != Integer.MIN_VALUE;
    }

    public void copyFrom(AnimationState p_363137_) {
        this.startTick = p_363137_.startTick;
    }
}

