/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public interface StrictQueue<T extends Runnable> {
    @Nullable
    public Runnable pop();

    public boolean push(T var1);

    public boolean isEmpty();

    public int size();

    public static final class FixedPriorityQueue
    implements StrictQueue<RunnableWithPriority> {
        private final Queue<Runnable>[] queues;
        private final AtomicInteger size = new AtomicInteger();

        public FixedPriorityQueue(int p_18773_) {
            this.queues = new Queue[p_18773_];
            for (int $$1 = 0; $$1 < p_18773_; ++$$1) {
                this.queues[$$1] = Queues.newConcurrentLinkedQueue();
            }
        }

        @Override
        @Nullable
        public Runnable pop() {
            for (Queue<Runnable> $$0 : this.queues) {
                Runnable $$1 = $$0.poll();
                if ($$1 == null) continue;
                this.size.decrementAndGet();
                return $$1;
            }
            return null;
        }

        @Override
        public boolean push(RunnableWithPriority p_371717_) {
            int $$1 = p_371717_.priority;
            if ($$1 >= this.queues.length || $$1 < 0) {
                throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Priority %d not supported. Expected range [0-%d]", $$1, this.queues.length - 1));
            }
            this.queues[$$1].add(p_371717_);
            this.size.incrementAndGet();
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size.get() == 0;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    }

    public record RunnableWithPriority(int priority, Runnable task) implements Runnable
    {
        @Override
        public void run() {
            this.task.run();
        }
    }

    public static final class QueueStrictQueue
    implements StrictQueue<Runnable> {
        private final Queue<Runnable> queue;

        public QueueStrictQueue(Queue<Runnable> p_18792_) {
            this.queue = p_18792_;
        }

        @Override
        @Nullable
        public Runnable pop() {
            return this.queue.poll();
        }

        @Override
        public boolean push(Runnable p_371489_) {
            return this.queue.add(p_371489_);
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

