/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;

public class WeightedRandom {
    private WeightedRandom() {
    }

    public static <T> int getTotalWeight(List<T> p_146313_, ToIntFunction<T> p_393530_) {
        long $$2 = 0L;
        for (T $$3 : p_146313_) {
            $$2 += (long)p_393530_.applyAsInt($$3);
        }
        if ($$2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)$$2;
    }

    public static <T> Optional<T> getRandomItem(RandomSource p_216826_, List<T> p_216827_, int p_216828_, ToIntFunction<T> p_394361_) {
        if (p_216828_ < 0) {
            throw Util.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (p_216828_ == 0) {
            return Optional.empty();
        }
        int $$4 = p_216826_.nextInt(p_216828_);
        return WeightedRandom.getWeightedItem(p_216827_, $$4, p_394361_);
    }

    public static <T> Optional<T> getWeightedItem(List<T> p_146315_, int p_146316_, ToIntFunction<T> p_393515_) {
        for (T $$3 : p_146315_) {
            if ((p_146316_ -= p_393515_.applyAsInt($$3)) >= 0) continue;
            return Optional.of($$3);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getRandomItem(RandomSource p_216823_, List<T> p_216824_, ToIntFunction<T> p_393718_) {
        return WeightedRandom.getRandomItem(p_216823_, p_216824_, WeightedRandom.getTotalWeight(p_216824_, p_393718_), p_393718_);
    }
}

