/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ThrownPotionSplitFix
extends EntityRenameFix {
    private final Supplier<ItemIdFinder> itemIdFinder = Suppliers.memoize(() -> {
        Type $$0 = this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:potion");
        Type<?> $$1 = ExtraDataFixUtils.patchSubType($$0, this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY));
        OpticFinder $$2 = $$1.findField("Item");
        OpticFinder $$3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        return new ItemIdFinder($$2, (OpticFinder<Pair<String, String>>)$$3);
    });

    public ThrownPotionSplitFix(Schema p_399557_) {
        super("ThrownPotionSplitFix", p_399557_, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String p_399987_, Typed<?> p_399615_) {
        if (!p_399987_.equals("minecraft:potion")) {
            return Pair.of((Object)p_399987_, p_399615_);
        }
        String $$2 = this.itemIdFinder.get().getItemId(p_399615_);
        if ("minecraft:lingering_potion".equals($$2)) {
            return Pair.of((Object)"minecraft:lingering_potion", p_399615_);
        }
        return Pair.of((Object)"minecraft:splash_potion", p_399615_);
    }

    record ItemIdFinder(OpticFinder<?> itemFinder, OpticFinder<Pair<String, String>> itemIdFinder) {
        public String getItemId(Typed<?> p_400206_) {
            return p_400206_.getOptionalTyped(this.itemFinder).flatMap(p_400219_ -> p_400219_.getOptional(this.itemIdFinder)).map(Pair::getSecond).map(NamespacedSchema::ensureNamespaced).orElse("");
        }
    }
}

