/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.AbstractUUIDFix;
import net.minecraft.util.datafix.fixes.References;
import org.slf4j.Logger;

public class LevelUUIDFix
extends AbstractUUIDFix {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LevelUUIDFix(Schema p_16360_) {
        super(p_16360_, References.LEVEL);
    }

    protected TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(this.typeReference);
        OpticFinder $$1 = $$0.findField("CustomBossEvents");
        OpticFinder $$2 = DSL.typeFinder((Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Name", (Type)this.getInputSchema().getTypeRaw(References.TEXT_COMPONENT))), (Type)DSL.remainderType()));
        return this.fixTypeEverywhereTyped("LevelUUIDFix", $$0, p_392870_ -> p_392870_.update(DSL.remainderFinder(), p_392865_ -> {
            p_392865_ = this.updateDragonFight((Dynamic<?>)p_392865_);
            p_392865_ = this.updateWanderingTrader((Dynamic<?>)p_392865_);
            return p_392865_;
        }).updateTyped($$1, p_392867_ -> p_392867_.updateTyped($$2, p_145496_ -> p_145496_.update(DSL.remainderFinder(), this::updateCustomBossEvent))));
    }

    private Dynamic<?> updateWanderingTrader(Dynamic<?> p_16373_) {
        return LevelUUIDFix.replaceUUIDString(p_16373_, "WanderingTraderId", "WanderingTraderId").orElse(p_16373_);
    }

    private Dynamic<?> updateDragonFight(Dynamic<?> p_16375_) {
        return p_16375_.update("DimensionData", p_16379_ -> p_16379_.updateMapValues(p_145491_ -> p_145491_.mapSecond(p_145506_ -> p_145506_.update("DragonFight", p_145508_ -> LevelUUIDFix.replaceUUIDLeastMost(p_145508_, "DragonUUID", "Dragon").orElse((Dynamic<?>)p_145508_)))));
    }

    private Dynamic<?> updateCustomBossEvent(Dynamic<?> p_393606_) {
        return p_393606_.update("Players", p_145494_ -> p_393606_.createList(p_145494_.asStream().map(p_145502_ -> LevelUUIDFix.createUUIDFromML(p_145502_).orElseGet(() -> {
            LOGGER.warn("CustomBossEvents contains invalid UUIDs.");
            return p_145502_;
        }))));
    }
}

