/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.References;

public class EntityProjectileOwnerFix
extends DataFix {
    public EntityProjectileOwnerFix(Schema p_15558_) {
        super(p_15558_, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema $$0 = this.getInputSchema();
        return this.fixTypeEverywhereTyped("EntityProjectileOwner", $$0.getType(References.ENTITY), this::updateProjectiles);
    }

    private Typed<?> updateProjectiles(Typed<?> p_15563_) {
        p_15563_ = this.updateEntity(p_15563_, "minecraft:egg", this::updateOwnerThrowable);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:ender_pearl", this::updateOwnerThrowable);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:experience_bottle", this::updateOwnerThrowable);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:snowball", this::updateOwnerThrowable);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:potion", this::updateOwnerThrowable);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:llama_spit", this::updateOwnerLlamaSpit);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:arrow", this::updateOwnerArrow);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:spectral_arrow", this::updateOwnerArrow);
        p_15563_ = this.updateEntity(p_15563_, "minecraft:trident", this::updateOwnerArrow);
        return p_15563_;
    }

    private Dynamic<?> updateOwnerArrow(Dynamic<?> p_15569_) {
        long $$1 = p_15569_.get("OwnerUUIDMost").asLong(0L);
        long $$2 = p_15569_.get("OwnerUUIDLeast").asLong(0L);
        return this.setUUID(p_15569_, $$1, $$2).remove("OwnerUUIDMost").remove("OwnerUUIDLeast");
    }

    private Dynamic<?> updateOwnerLlamaSpit(Dynamic<?> p_15578_) {
        OptionalDynamic $$1 = p_15578_.get("Owner");
        long $$2 = $$1.get("OwnerUUIDMost").asLong(0L);
        long $$3 = $$1.get("OwnerUUIDLeast").asLong(0L);
        return this.setUUID(p_15578_, $$2, $$3).remove("Owner");
    }

    private Dynamic<?> updateOwnerThrowable(Dynamic<?> p_15582_) {
        String $$1 = "owner";
        OptionalDynamic $$2 = p_15582_.get("owner");
        long $$3 = $$2.get("M").asLong(0L);
        long $$4 = $$2.get("L").asLong(0L);
        return this.setUUID(p_15582_, $$3, $$4).remove("owner");
    }

    private Dynamic<?> setUUID(Dynamic<?> p_15571_, long p_15572_, long p_15573_) {
        String $$3 = "OwnerUUID";
        if (p_15572_ != 0L && p_15573_ != 0L) {
            return p_15571_.set("OwnerUUID", p_15571_.createIntList(Arrays.stream(EntityProjectileOwnerFix.createUUIDArray(p_15572_, p_15573_))));
        }
        return p_15571_;
    }

    private static int[] createUUIDArray(long p_15560_, long p_15561_) {
        return new int[]{(int)(p_15560_ >> 32), (int)p_15560_, (int)(p_15561_ >> 32), (int)p_15561_};
    }

    private Typed<?> updateEntity(Typed<?> p_15565_, String p_15566_, Function<Dynamic<?>, Dynamic<?>> p_15567_) {
        Type $$3 = this.getInputSchema().getChoiceType(References.ENTITY, p_15566_);
        Type $$4 = this.getOutputSchema().getChoiceType(References.ENTITY, p_15566_);
        return p_15565_.updateTyped(DSL.namedChoice((String)p_15566_, (Type)$$3), $$4, p_15576_ -> p_15576_.update(DSL.remainderFinder(), p_15567_));
    }
}

