/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class EntityEquipmentToArmorAndHandFix
extends DataFix {
    public EntityEquipmentToArmorAndHandFix(Schema p_15417_) {
        super(p_15417_, true);
    }

    public TypeRewriteRule makeRule() {
        return this.cap(this.getInputSchema().getTypeRaw(References.ITEM_STACK), this.getOutputSchema().getTypeRaw(References.ITEM_STACK));
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule cap(Type<ItemStackOld> p_15427_, Type<ItemStackNew> p_397424_) {
        Type $$2 = DSL.named((String)References.ENTITY_EQUIPMENT.typeName(), (Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(p_15427_))));
        Type $$3 = DSL.named((String)References.ENTITY_EQUIPMENT.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(p_397424_))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(p_397424_))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", p_397424_)), (Type)DSL.optional((Type)DSL.field((String)"saddle", p_397424_))));
        if (!$$2.equals((Object)this.getInputSchema().getType(References.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!$$3.equals((Object)this.getOutputSchema().getType(References.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix - drop chances", this.getInputSchema().getType(References.ENTITY), p_396575_ -> p_396575_.update(DSL.remainderFinder(), EntityEquipmentToArmorAndHandFix::fixDropChances)), (TypeRewriteRule)this.fixTypeEverywhere("EntityEquipmentToArmorAndHandFix - equipment", $$2, $$3, p_396584_ -> {
            Object $$2 = ((Pair)p_397424_.read(new Dynamic(p_396584_).emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
            Either $$3 = Either.right((Object)DSL.unit());
            return p_396581_ -> p_396581_.mapSecond(p_396578_ -> {
                List $$3 = (List)p_396578_.map(Function.identity(), p_396582_ -> List.of());
                Either $$4 = Either.right((Object)DSL.unit());
                Either $$5 = Either.right((Object)DSL.unit());
                if (!$$3.isEmpty()) {
                    $$4 = Either.left((Object)Lists.newArrayList((Object[])new Object[]{$$3.getFirst(), $$2}));
                }
                if ($$3.size() > 1) {
                    ArrayList $$6 = Lists.newArrayList((Object[])new Object[]{$$2, $$2, $$2, $$2});
                    for (int $$7 = 1; $$7 < Math.min($$3.size(), 5); ++$$7) {
                        $$6.set($$7 - 1, $$3.get($$7));
                    }
                    $$5 = Either.left((Object)$$6);
                }
                return Pair.of((Object)$$5, (Object)Pair.of((Object)$$4, (Object)Pair.of((Object)$$3, (Object)$$3)));
            });
        }));
    }

    private static Dynamic<?> fixDropChances(Dynamic<?> p_397744_) {
        Optional $$1 = p_397744_.get("DropChances").asStreamOpt().result();
        p_397744_ = p_397744_.remove("DropChances");
        if ($$1.isPresent()) {
            Iterator $$2 = Stream.concat(((Stream)$$1.get()).map(p_396585_ -> Float.valueOf(p_396585_.asFloat(0.0f))), Stream.generate(() -> Float.valueOf(0.0f))).iterator();
            float $$3 = ((Float)$$2.next()).floatValue();
            if (p_397744_.get("HandDropChances").result().isEmpty()) {
                p_397744_ = p_397744_.set("HandDropChances", p_397744_.createList(Stream.of(Float.valueOf($$3), Float.valueOf(0.0f)).map(arg_0 -> ((Dynamic)p_397744_).createFloat(arg_0))));
            }
            if (p_397744_.get("ArmorDropChances").result().isEmpty()) {
                p_397744_ = p_397744_.set("ArmorDropChances", p_397744_.createList(Stream.of((Float)$$2.next(), (Float)$$2.next(), (Float)$$2.next(), (Float)$$2.next()).map(arg_0 -> ((Dynamic)p_397744_).createFloat(arg_0))));
            }
        }
        return p_397744_;
    }
}

