/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class BlockEntityCustomNameToComponentFix
extends DataFix {
    private static final Set<String> NAMEABLE_BLOCK_ENTITIES = Set.of("minecraft:beacon", "minecraft:banner", "minecraft:brewing_stand", "minecraft:chest", "minecraft:trapped_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:enchanting_table", "minecraft:furnace", "minecraft:hopper", "minecraft:shulker_box");

    public BlockEntityCustomNameToComponentFix(Schema p_14817_) {
        super(p_14817_, true);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder $$0 = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        Type $$1 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type $$2 = this.getOutputSchema().getType(References.BLOCK_ENTITY);
        Type<?> $$3 = ExtraDataFixUtils.patchSubType($$1, $$1, $$2);
        return this.fixTypeEverywhereTyped("BlockEntityCustomNameToComponentFix", $$1, $$2, p_392814_ -> {
            Optional $$4 = p_392814_.getOptional($$0);
            if ($$4.isPresent() && !NAMEABLE_BLOCK_ENTITIES.contains($$4.get())) {
                return ExtraDataFixUtils.cast($$2, p_392814_);
            }
            return Util.writeAndReadTypedOrThrow(ExtraDataFixUtils.cast($$3, p_392814_), $$2, BlockEntityCustomNameToComponentFix::fixTagCustomName);
        });
    }

    public static <T> Dynamic<T> fixTagCustomName(Dynamic<T> p_394274_) {
        String $$1 = p_394274_.get("CustomName").asString("");
        if ($$1.isEmpty()) {
            return p_394274_.remove("CustomName");
        }
        return p_394274_.set("CustomName", LegacyComponentDataFixUtils.createPlainTextComponent(p_394274_.getOps(), $$1));
    }
}

