/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;

public class ExtraCodecs {
    public static final Codec<JsonElement> JSON = ExtraCodecs.converter(JsonOps.INSTANCE);
    public static final Codec<Object> JAVA = ExtraCodecs.converter(JavaOps.INSTANCE);
    public static final Codec<Tag> NBT = ExtraCodecs.converter(NbtOps.INSTANCE);
    public static final Codec<Vector2f> VECTOR2F = Codec.FLOAT.listOf().comapFlatMap(p_417757_ -> Util.fixedSize(p_417757_, 2).map(p_417754_ -> new Vector2f(((Float)p_417754_.get(0)).floatValue(), ((Float)p_417754_.get(1)).floatValue())), p_417755_ -> List.of(Float.valueOf(p_417755_.x()), Float.valueOf(p_417755_.y())));
    public static final Codec<Vector3f> VECTOR3F = Codec.FLOAT.listOf().comapFlatMap(p_337581_ -> Util.fixedSize(p_337581_, 3).map(p_253489_ -> new Vector3f(((Float)p_253489_.get(0)).floatValue(), ((Float)p_253489_.get(1)).floatValue(), ((Float)p_253489_.get(2)).floatValue())), p_269787_ -> List.of(Float.valueOf(p_269787_.x()), Float.valueOf(p_269787_.y()), Float.valueOf(p_269787_.z())));
    public static final Codec<Vector3i> VECTOR3I = Codec.INT.listOf().comapFlatMap(p_417758_ -> Util.fixedSize(p_417758_, 3).map(p_417756_ -> new Vector3i(((Integer)p_417756_.get(0)).intValue(), ((Integer)p_417756_.get(1)).intValue(), ((Integer)p_417756_.get(2)).intValue())), p_417753_ -> List.of(Integer.valueOf(p_417753_.x()), Integer.valueOf(p_417753_.y()), Integer.valueOf(p_417753_.z())));
    public static final Codec<Vector4f> VECTOR4F = Codec.FLOAT.listOf().comapFlatMap(p_337575_ -> Util.fixedSize(p_337575_, 4).map(p_340675_ -> new Vector4f(((Float)p_340675_.get(0)).floatValue(), ((Float)p_340675_.get(1)).floatValue(), ((Float)p_340675_.get(2)).floatValue(), ((Float)p_340675_.get(3)).floatValue())), p_340674_ -> List.of(Float.valueOf(p_340674_.x()), Float.valueOf(p_340674_.y()), Float.valueOf(p_340674_.z()), Float.valueOf(p_340674_.w())));
    public static final Codec<Quaternionf> QUATERNIONF_COMPONENTS = Codec.FLOAT.listOf().comapFlatMap(p_340677_ -> Util.fixedSize(p_340677_, 4).map(p_351780_ -> new Quaternionf(((Float)p_351780_.get(0)).floatValue(), ((Float)p_351780_.get(1)).floatValue(), ((Float)p_351780_.get(2)).floatValue(), ((Float)p_351780_.get(3)).floatValue()).normalize()), p_269780_ -> List.of(Float.valueOf(p_269780_.x), Float.valueOf(p_269780_.y), Float.valueOf(p_269780_.z), Float.valueOf(p_269780_.w)));
    public static final Codec<AxisAngle4f> AXISANGLE4F = RecordCodecBuilder.create(p_269774_ -> p_269774_.group((App)Codec.FLOAT.fieldOf("angle").forGetter(p_269776_ -> Float.valueOf(p_269776_.angle)), (App)VECTOR3F.fieldOf("axis").forGetter(p_269778_ -> new Vector3f(p_269778_.x, p_269778_.y, p_269778_.z))).apply((Applicative)p_269774_, AxisAngle4f::new));
    public static final Codec<Quaternionf> QUATERNIONF = Codec.withAlternative(QUATERNIONF_COMPONENTS, (Codec)AXISANGLE4F.xmap(Quaternionf::new, AxisAngle4f::new));
    public static final Codec<Matrix4fc> MATRIX4F = Codec.FLOAT.listOf().comapFlatMap(p_337582_ -> Util.fixedSize(p_337582_, 16).map(p_269777_ -> {
        Matrix4f $$1 = new Matrix4f();
        for (int $$2 = 0; $$2 < p_269777_.size(); ++$$2) {
            $$1.setRowColumn($$2 >> 2, $$2 & 3, ((Float)p_269777_.get($$2)).floatValue());
        }
        return $$1.determineProperties();
    }), p_404240_ -> {
        FloatArrayList $$1 = new FloatArrayList(16);
        for (int $$2 = 0; $$2 < 16; ++$$2) {
            $$1.add(p_404240_.getRowColumn($$2 >> 2, $$2 & 3));
        }
        return $$1;
    });
    public static final Codec<Integer> RGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, VECTOR3F, p_370488_ -> ARGB.colorFromFloat(1.0f, p_370488_.x(), p_370488_.y(), p_370488_.z()));
    public static final Codec<Integer> ARGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, VECTOR4F, p_359661_ -> ARGB.colorFromFloat(p_359661_.w(), p_359661_.x(), p_359661_.y(), p_359661_.z()));
    public static final Codec<Integer> UNSIGNED_BYTE = Codec.BYTE.flatComapMap(UnsignedBytes::toInt, p_324632_ -> {
        if (p_324632_ > 255) {
            return DataResult.error(() -> "Unsigned byte was too large: " + p_324632_ + " > 255");
        }
        return DataResult.success((Object)p_324632_.byteValue());
    });
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, p_405214_ -> "Value must be non-negative: " + p_405214_);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, p_418205_ -> "Value must be positive: " + p_418205_);
    public static final Codec<Float> NON_NEGATIVE_FLOAT = ExtraCodecs.floatRangeMinInclusiveWithMessage(0.0f, Float.MAX_VALUE, p_404968_ -> "Value must be non-negative: " + p_404968_);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, p_418150_ -> "Value must be positive: " + p_418150_);
    public static final Codec<Pattern> PATTERN = Codec.STRING.comapFlatMap(p_274857_ -> {
        try {
            return DataResult.success((Object)Pattern.compile(p_274857_));
        }
        catch (PatternSyntaxException $$1) {
            return DataResult.error(() -> "Invalid regex pattern '" + p_274857_ + "': " + $$1.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> INSTANT_ISO8601 = ExtraCodecs.temporalCodec(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> BASE64_STRING = Codec.STRING.comapFlatMap(p_274852_ -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)p_274852_));
        }
        catch (IllegalArgumentException $$1) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, p_216180_ -> Base64.getEncoder().encodeToString((byte[])p_216180_));
    public static final Codec<String> ESCAPED_STRING = Codec.STRING.comapFlatMap(p_301741_ -> DataResult.success((Object)StringEscapeUtils.unescapeJava((String)p_301741_)), StringEscapeUtils::escapeJava);
    public static final Codec<TagOrElementLocation> TAG_OR_ELEMENT_ID = Codec.STRING.comapFlatMap(p_337578_ -> p_337578_.startsWith("#") ? ResourceLocation.read(p_337578_.substring(1)).map(p_216182_ -> new TagOrElementLocation((ResourceLocation)p_216182_, true)) : ResourceLocation.read(p_337578_).map(p_216165_ -> new TagOrElementLocation((ResourceLocation)p_216165_, false)), TagOrElementLocation::decoratedId);
    public static final Function<Optional<Long>, OptionalLong> toOptionalLong = p_216176_ -> p_216176_.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> fromOptionalLong = p_216178_ -> p_216178_.isPresent() ? Optional.of(p_216178_.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> BIT_SET = Codec.LONG_STREAM.xmap(p_253514_ -> BitSet.valueOf(p_253514_.toArray()), p_253493_ -> Arrays.stream(p_253493_.toLongArray()));
    private static final Codec<Property> PROPERTY = RecordCodecBuilder.create(p_337580_ -> p_337580_.group((App)Codec.STRING.fieldOf("name").forGetter(Property::name), (App)Codec.STRING.fieldOf("value").forGetter(Property::value), (App)Codec.STRING.lenientOptionalFieldOf("signature").forGetter(p_293823_ -> Optional.ofNullable(p_293823_.signature()))).apply((Applicative)p_337580_, (p_253494_, p_253495_, p_253496_) -> new Property(p_253494_, p_253495_, (String)p_253496_.orElse(null))));
    public static final Codec<PropertyMap> PROPERTY_MAP = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)PROPERTY.listOf()).xmap(p_253515_ -> {
        PropertyMap $$1 = new PropertyMap();
        p_253515_.ifLeft(p_253506_ -> p_253506_.forEach((p_253500_, p_253501_) -> {
            for (String $$3 : p_253501_) {
                $$1.put(p_253500_, (Object)new Property(p_253500_, $$3));
            }
        })).ifRight(p_293821_ -> {
            for (Property $$2 : p_293821_) {
                $$1.put((Object)$$2.name(), (Object)$$2);
            }
        });
        return $$1;
    }, p_253504_ -> Either.right(p_253504_.values().stream().toList()));
    public static final Codec<String> PLAYER_NAME = Codec.string((int)0, (int)16).validate(p_329972_ -> {
        if (StringUtil.isValidPlayerName(p_329972_)) {
            return DataResult.success((Object)p_329972_);
        }
        return DataResult.error(() -> "Player name contained disallowed characters: '" + p_329972_ + "'");
    });
    private static final MapCodec<GameProfile> GAME_PROFILE_WITHOUT_PROPERTIES = RecordCodecBuilder.mapCodec(p_329970_ -> p_329970_.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("id").forGetter(GameProfile::getId), (App)PLAYER_NAME.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)p_329970_, GameProfile::new));
    public static final Codec<GameProfile> GAME_PROFILE = RecordCodecBuilder.create(p_337579_ -> p_337579_.group((App)GAME_PROFILE_WITHOUT_PROPERTIES.forGetter(Function.identity()), (App)PROPERTY_MAP.lenientOptionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)p_337579_, (p_253518_, p_253519_) -> {
        p_253519_.forEach((p_253511_, p_253512_) -> p_253518_.getProperties().put(p_253511_, p_253512_));
        return p_253518_;
    }));
    public static final Codec<String> NON_EMPTY_STRING = Codec.STRING.validate(p_274858_ -> p_274858_.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)p_274858_));
    public static final Codec<Integer> CODEPOINT = Codec.STRING.comapFlatMap(p_284688_ -> {
        int[] $$1 = p_284688_.codePoints().toArray();
        if ($$1.length != 1) {
            return DataResult.error(() -> "Expected one codepoint, got: " + p_284688_);
        }
        return DataResult.success((Object)$$1[0]);
    }, Character::toString);
    public static final Codec<String> RESOURCE_PATH_CODEC = Codec.STRING.validate(p_293822_ -> {
        if (!ResourceLocation.isValidPath(p_293822_)) {
            return DataResult.error(() -> "Invalid string to use as a resource path element: " + p_293822_);
        }
        return DataResult.success((Object)p_293822_);
    });
    public static final Codec<URI> UNTRUSTED_URI = Codec.STRING.comapFlatMap(p_392801_ -> {
        try {
            return DataResult.success((Object)Util.parseAndValidateUntrustedUri(p_392801_));
        }
        catch (URISyntaxException $$1) {
            return DataResult.error($$1::getMessage);
        }
    }, URI::toString);
    public static final Codec<String> CHAT_STRING = Codec.STRING.validate(p_392800_ -> {
        for (int $$1 = 0; $$1 < p_392800_.length(); ++$$1) {
            char $$2 = p_392800_.charAt($$1);
            if (StringUtil.isAllowedChatCharacter($$2)) continue;
            return DataResult.error(() -> "Disallowed chat character: '" + $$2 + "'");
        }
        return DataResult.success((Object)p_392800_);
    });

    public static <T> Codec<T> converter(DynamicOps<T> p_304929_) {
        return Codec.PASSTHROUGH.xmap(p_304323_ -> p_304323_.convert(p_304929_).getValue(), p_304327_ -> new Dynamic(p_304929_, p_304327_));
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> p_184362_, String p_184363_, String p_184364_, BiFunction<P, P, DataResult<I>> p_184365_, Function<I, P> p_184366_, Function<I, P> p_184367_) {
        Codec $$6 = Codec.list(p_184362_).comapFlatMap(p_337577_ -> Util.fixedSize(p_337577_, 2).flatMap(p_184445_ -> {
            Object $$2 = p_184445_.get(0);
            Object $$3 = p_184445_.get(1);
            return (DataResult)p_184365_.apply($$2, $$3);
        }), p_184459_ -> ImmutableList.of(p_184366_.apply(p_184459_), p_184367_.apply(p_184459_)));
        Codec $$7 = RecordCodecBuilder.create(p_184360_ -> p_184360_.group((App)p_184362_.fieldOf(p_184363_).forGetter(Pair::getFirst), (App)p_184362_.fieldOf(p_184364_).forGetter(Pair::getSecond)).apply((Applicative)p_184360_, Pair::of)).comapFlatMap(p_184392_ -> (DataResult)p_184365_.apply(p_184392_.getFirst(), p_184392_.getSecond()), p_184449_ -> Pair.of(p_184366_.apply(p_184449_), p_184367_.apply(p_184449_)));
        Codec $$8 = Codec.withAlternative((Codec)$$6, (Codec)$$7);
        return Codec.either(p_184362_, (Codec)$$8).comapFlatMap(p_184389_ -> (DataResult)p_184389_.map(p_184395_ -> (DataResult)p_184365_.apply(p_184395_, p_184395_), DataResult::success), p_184411_ -> {
            Object $$4;
            Object $$3 = p_184366_.apply(p_184411_);
            if (Objects.equals($$3, $$4 = p_184367_.apply(p_184411_))) {
                return Either.left($$3);
            }
            return Either.right((Object)p_184411_);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(final A p_184382_) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> p_184466_, T p_184467_, DataResult<Pair<A, T>> p_184468_) {
                MutableObject $$3 = new MutableObject();
                Optional $$4 = p_184468_.resultOrPartial(arg_0 -> ((MutableObject)$$3).setValue(arg_0));
                if ($$4.isPresent()) {
                    return p_184468_;
                }
                return DataResult.error(() -> "(" + (String)$$3.getValue() + " -> using default)", (Object)Pair.of((Object)p_184382_, p_184467_));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_184470_, A p_184471_, DataResult<T> p_184472_) {
                return p_184472_;
            }

            public String toString() {
                return "OrElsePartial[" + String.valueOf(p_184382_) + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> p_184422_, IntFunction<E> p_184423_, int p_184424_) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(p_184423_.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + p_184414_)), p_274850_ -> {
            int $$3 = p_184422_.applyAsInt(p_274850_);
            return $$3 == p_184424_ ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(p_274850_)) : DataResult.success((Object)$$3);
        });
    }

    public static <I, E> Codec<E> idResolverCodec(Codec<I> p_387806_, Function<I, E> p_386962_, Function<E, I> p_388355_) {
        return p_387806_.flatXmap(p_386303_ -> {
            Object $$2 = p_386962_.apply(p_386303_);
            return $$2 == null ? DataResult.error(() -> "Unknown element id: " + String.valueOf(p_386303_)) : DataResult.success($$2);
        }, p_386309_ -> {
            Object $$2 = p_388355_.apply(p_386309_);
            if ($$2 == null) {
                return DataResult.error(() -> "Element with unknown id: " + String.valueOf(p_386309_));
            }
            return DataResult.success($$2);
        });
    }

    public static <E> Codec<E> orCompressed(final Codec<E> p_184426_, final Codec<E> p_184427_) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                if (p_184484_.compressMaps()) {
                    return p_184427_.encode(p_184483_, p_184484_, p_184485_);
                }
                return p_184426_.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                if (p_184480_.compressMaps()) {
                    return p_184427_.decode(p_184480_, p_184481_);
                }
                return p_184426_.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return String.valueOf(p_184426_) + " orCompressed " + String.valueOf(p_184427_);
            }
        };
    }

    public static <E> MapCodec<E> orCompressed(final MapCodec<E> p_304545_, final MapCodec<E> p_304716_) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E p_304635_, DynamicOps<T> p_304428_, RecordBuilder<T> p_304777_) {
                if (p_304428_.compressMaps()) {
                    return p_304716_.encode(p_304635_, p_304428_, p_304777_);
                }
                return p_304545_.encode(p_304635_, p_304428_, p_304777_);
            }

            public <T> DataResult<E> decode(DynamicOps<T> p_304666_, MapLike<T> p_304870_) {
                if (p_304666_.compressMaps()) {
                    return p_304716_.decode(p_304666_, p_304870_);
                }
                return p_304545_.decode(p_304666_, p_304870_);
            }

            public <T> Stream<T> keys(DynamicOps<T> p_304533_) {
                return p_304716_.keys(p_304533_);
            }

            public String toString() {
                return String.valueOf(p_304545_) + " orCompressed " + String.valueOf(p_304716_);
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> p_184369_, final Function<E, Lifecycle> p_184370_, final Function<E, Lifecycle> p_184371_) {
        return p_184369_.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> p_304965_, T p_304933_, DataResult<Pair<E, T>> p_304851_) {
                return p_304851_.result().map(p_337585_ -> p_304851_.setLifecycle((Lifecycle)p_184370_.apply(p_337585_.getFirst()))).orElse(p_304851_);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> p_304780_, E p_304414_, DataResult<T> p_304779_) {
                return p_304779_.setLifecycle((Lifecycle)p_184371_.apply(p_304414_));
            }

            public String toString() {
                return "WithLifecycle[" + String.valueOf(p_184370_) + " " + String.valueOf(p_184371_) + "]";
            }
        });
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> p_326460_, Function<E, Lifecycle> p_326480_) {
        return ExtraCodecs.overrideLifecycle(p_326460_, p_326480_, p_326480_);
    }

    public static <K, V> StrictUnboundedMapCodec<K, V> strictUnboundedMap(Codec<K> p_301201_, Codec<V> p_300984_) {
        return new StrictUnboundedMapCodec<K, V>(p_301201_, p_300984_);
    }

    public static <E> Codec<List<E>> compactListCodec(Codec<E> p_388265_) {
        return ExtraCodecs.compactListCodec(p_388265_, p_388265_.listOf());
    }

    public static <E> Codec<List<E>> compactListCodec(Codec<E> p_387241_, Codec<List<E>> p_387761_) {
        return Codec.either(p_387761_, p_387241_).xmap(p_386305_ -> (List)p_386305_.map(p_386307_ -> p_386307_, List::of), p_386301_ -> p_386301_.size() == 1 ? Either.right(p_386301_.getFirst()) : Either.left((Object)p_386301_));
    }

    private static Codec<Integer> intRangeWithMessage(int p_144634_, int p_144635_, Function<Integer, String> p_144636_) {
        return Codec.INT.validate(p_274889_ -> {
            if (p_274889_.compareTo(p_144634_) >= 0 && p_274889_.compareTo(p_144635_) <= 0) {
                return DataResult.success((Object)p_274889_);
            }
            return DataResult.error(() -> (String)p_144636_.apply((Integer)p_274889_));
        });
    }

    public static Codec<Integer> intRange(int p_270883_, int p_270323_) {
        return ExtraCodecs.intRangeWithMessage(p_270883_, p_270323_, p_269784_ -> "Value must be within range [" + p_270883_ + ";" + p_270323_ + "]: " + p_269784_);
    }

    private static Codec<Float> floatRangeMinInclusiveWithMessage(float p_366455_, float p_366519_, Function<Float, String> p_366799_) {
        return Codec.FLOAT.validate(p_366383_ -> {
            if (p_366383_.compareTo(Float.valueOf(p_366455_)) >= 0 && p_366383_.compareTo(Float.valueOf(p_366519_)) <= 0) {
                return DataResult.success((Object)p_366383_);
            }
            return DataResult.error(() -> (String)p_366799_.apply((Float)p_366383_));
        });
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float p_184351_, float p_184352_, Function<Float, String> p_184353_) {
        return Codec.FLOAT.validate(p_274865_ -> {
            if (p_274865_.compareTo(Float.valueOf(p_184351_)) > 0 && p_274865_.compareTo(Float.valueOf(p_184352_)) <= 0) {
                return DataResult.success((Object)p_274865_);
            }
            return DataResult.error(() -> (String)p_184353_.apply((Float)p_274865_));
        });
    }

    public static Codec<Float> floatRange(float p_386629_, float p_387660_) {
        return ExtraCodecs.floatRangeMinInclusiveWithMessage(p_386629_, p_387660_, p_386312_ -> "Value must be within range [" + p_386629_ + ";" + p_387660_ + "]: " + p_386312_);
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> p_144638_) {
        return p_144638_.validate(p_274853_ -> p_274853_.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)p_274853_));
    }

    public static <T> Codec<HolderSet<T>> nonEmptyHolderSet(Codec<HolderSet<T>> p_203983_) {
        return p_203983_.validate(p_274860_ -> {
            if (p_274860_.unwrap().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)p_274860_);
        });
    }

    public static <M extends Map<?, ?>> Codec<M> nonEmptyMap(Codec<M> p_371510_) {
        return p_371510_.validate(p_370487_ -> p_370487_.isEmpty() ? DataResult.error(() -> "Map must have contents") : DataResult.success((Object)p_370487_));
    }

    public static <E> MapCodec<E> retrieveContext(Function<DynamicOps<?>, DataResult<E>> p_203977_) {
        class ContextRetrievalCodec
        extends MapCodec<E> {
            final /* synthetic */ Function val$getter;

            ContextRetrievalCodec(Function function) {
                this.val$getter = function;
            }

            public <T> RecordBuilder<T> encode(E p_203993_, DynamicOps<T> p_203994_, RecordBuilder<T> p_203995_) {
                return p_203995_;
            }

            public <T> DataResult<E> decode(DynamicOps<T> p_203990_, MapLike<T> p_203991_) {
                return (DataResult)this.val$getter.apply(p_203990_);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + String.valueOf(this.val$getter) + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> p_203997_) {
                return Stream.empty();
            }
        }
        return new ContextRetrievalCodec(p_203977_);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> ensureHomogenous(Function<E, T> p_203985_) {
        return p_203980_ -> {
            Iterator $$2 = p_203980_.iterator();
            if ($$2.hasNext()) {
                Object $$3 = p_203985_.apply($$2.next());
                while ($$2.hasNext()) {
                    Object $$4 = $$2.next();
                    Object $$5 = p_203985_.apply($$4);
                    if ($$5 == $$3) continue;
                    return DataResult.error(() -> "Mixed type list: element " + String.valueOf($$4) + " had type " + String.valueOf($$5) + ", but list is of type " + String.valueOf($$3));
                }
            }
            return DataResult.success((Object)p_203980_, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> catchDecoderException(final Codec<A> p_216186_) {
        return Codec.of(p_216186_, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> p_304559_, T p_304739_) {
                try {
                    return p_216186_.decode(p_304559_, p_304739_);
                }
                catch (Exception $$2) {
                    return DataResult.error(() -> "Caught exception decoding " + String.valueOf(p_304739_) + ": " + $$2.getMessage());
                }
            }
        });
    }

    public static Codec<TemporalAccessor> temporalCodec(DateTimeFormatter p_216171_) {
        return Codec.STRING.comapFlatMap(p_300789_ -> {
            try {
                return DataResult.success((Object)p_216171_.parse((CharSequence)p_300789_));
            }
            catch (Exception $$2) {
                return DataResult.error($$2::getMessage);
            }
        }, p_216171_::format);
    }

    public static MapCodec<OptionalLong> asOptionalLong(MapCodec<Optional<Long>> p_216167_) {
        return p_216167_.xmap(toOptionalLong, fromOptionalLong);
    }

    public static <K, V> Codec<Map<K, V>> sizeLimitedMap(Codec<Map<K, V>> p_330976_, int p_331151_) {
        return p_330976_.validate(p_329967_ -> {
            if (p_329967_.size() > p_331151_) {
                return DataResult.error(() -> "Map is too long: " + p_329967_.size() + ", expected range [0-" + p_331151_ + "]");
            }
            return DataResult.success((Object)p_329967_);
        });
    }

    public static <T> Codec<Object2BooleanMap<T>> object2BooleanMap(Codec<T> p_298255_) {
        return Codec.unboundedMap(p_298255_, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2ObjectOpenHashMap::new);
    }

    @Deprecated
    public static <K, V> MapCodec<V> dispatchOptionalValue(final String p_312812_, final String p_312135_, final Codec<K> p_312848_, final Function<? super V, ? extends K> p_312622_, final Function<? super K, ? extends Codec<? extends V>> p_312836_) {
        return new MapCodec<V>(){

            public <T> Stream<T> keys(DynamicOps<T> p_312501_) {
                return Stream.of(p_312501_.createString(p_312812_), p_312501_.createString(p_312135_));
            }

            public <T> DataResult<V> decode(DynamicOps<T> p_312013_, MapLike<T> p_312527_) {
                Object $$2 = p_312527_.get(p_312812_);
                if ($$2 == null) {
                    return DataResult.error(() -> "Missing \"" + p_312812_ + "\" in: " + String.valueOf(p_312527_));
                }
                return p_312848_.decode(p_312013_, $$2).flatMap(p_337590_ -> {
                    Object $$5 = Objects.requireNonNullElseGet(p_312527_.get(p_312135_), () -> ((DynamicOps)p_312013_).emptyMap());
                    return ((Codec)p_312836_.apply(p_337590_.getFirst())).decode(p_312013_, $$5).map(Pair::getFirst);
                });
            }

            public <T> RecordBuilder<T> encode(V p_312741_, DynamicOps<T> p_312649_, RecordBuilder<T> p_312297_) {
                Object $$3 = p_312622_.apply(p_312741_);
                p_312297_.add(p_312812_, p_312848_.encodeStart(p_312649_, $$3));
                DataResult<T> $$4 = this.encode((Codec)p_312836_.apply($$3), p_312741_, p_312649_);
                if ($$4.result().isEmpty() || !Objects.equals($$4.result().get(), p_312649_.emptyMap())) {
                    p_312297_.add(p_312135_, $$4);
                }
                return p_312297_;
            }

            private <T, V2 extends V> DataResult<T> encode(Codec<V2> p_312014_, V p_312190_, DynamicOps<T> p_312075_) {
                return p_312014_.encodeStart(p_312075_, p_312190_);
            }
        };
    }

    public static <A> Codec<Optional<A>> optionalEmptyMap(final Codec<A> p_330630_) {
        return new Codec<Optional<A>>(){

            public <T> DataResult<Pair<Optional<A>, T>> decode(DynamicOps<T> p_330879_, T p_330924_) {
                if (7.isEmptyMap(p_330879_, p_330924_)) {
                    return DataResult.success((Object)Pair.of(Optional.empty(), p_330924_));
                }
                return p_330630_.decode(p_330879_, p_330924_).map(p_337591_ -> p_337591_.mapFirst(Optional::of));
            }

            private static <T> boolean isEmptyMap(DynamicOps<T> p_338754_, T p_338581_) {
                Optional $$2 = p_338754_.getMap(p_338581_).result();
                return $$2.isPresent() && ((MapLike)$$2.get()).entries().findAny().isEmpty();
            }

            public <T> DataResult<T> encode(Optional<A> p_338508_, DynamicOps<T> p_331521_, T p_331876_) {
                if (p_338508_.isEmpty()) {
                    return DataResult.success((Object)p_331521_.emptyMap());
                }
                return p_330630_.encode(p_338508_.get(), p_331521_, p_331876_);
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((Optional)object, dynamicOps, object2);
            }
        };
    }

    @Deprecated
    public static <E extends Enum<E>> Codec<E> legacyEnum(Function<String, E> p_405687_) {
        return Codec.STRING.comapFlatMap(p_404242_ -> {
            try {
                return DataResult.success((Object)((Enum)p_405687_.apply((String)p_404242_)));
            }
            catch (IllegalArgumentException $$2) {
                return DataResult.error(() -> "No value with id: " + p_404242_);
            }
        }, Enum::toString);
    }

    public record StrictUnboundedMapCodec<K, V>(Codec<K> keyCodec, Codec<V> elementCodec) implements Codec<Map<K, V>>,
    BaseMapCodec<K, V>
    {
        public <T> DataResult<Map<K, V>> decode(DynamicOps<T> p_301018_, MapLike<T> p_301263_) {
            ImmutableMap.Builder $$2 = ImmutableMap.builder();
            for (Pair $$3 : p_301263_.entries().toList()) {
                DataResult $$5;
                DataResult $$4 = this.keyCodec().parse(p_301018_, $$3.getFirst());
                DataResult $$6 = $$4.apply2stable(Pair::of, $$5 = this.elementCodec().parse(p_301018_, $$3.getSecond()));
                Optional $$7 = $$6.error();
                if ($$7.isPresent()) {
                    String $$8 = ((DataResult.Error)$$7.get()).message();
                    return DataResult.error(() -> {
                        if ($$4.result().isPresent()) {
                            return "Map entry '" + String.valueOf($$4.result().get()) + "' : " + $$8;
                        }
                        return $$8;
                    });
                }
                if ($$6.result().isPresent()) {
                    Pair $$9 = (Pair)$$6.result().get();
                    $$2.put($$9.getFirst(), $$9.getSecond());
                    continue;
                }
                return DataResult.error(() -> "Empty or invalid map contents are not allowed");
            }
            ImmutableMap $$10 = $$2.build();
            return DataResult.success((Object)$$10);
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> p_301258_, T p_301052_) {
            return p_301258_.getMap(p_301052_).setLifecycle(Lifecycle.stable()).flatMap(p_301208_ -> this.decode(p_301258_, (Object)p_301208_)).map(p_300941_ -> Pair.of((Object)p_300941_, (Object)p_301052_));
        }

        public <T> DataResult<T> encode(Map<K, V> p_301101_, DynamicOps<T> p_301252_, T p_301326_) {
            return this.encode(p_301101_, p_301252_, p_301252_.mapBuilder()).build(p_301326_);
        }

        @Override
        public String toString() {
            return "StrictUnboundedMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Map)object, dynamicOps, object2);
        }
    }

    public record TagOrElementLocation(ResourceLocation id, boolean tag) {
        @Override
        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag ? "#" + String.valueOf(this.id) : this.id.toString();
        }
    }

    public static class LateBoundIdMapper<I, V> {
        private final BiMap<I, V> idToValue = HashBiMap.create();

        public Codec<V> codec(Codec<I> p_388140_) {
            BiMap $$1 = this.idToValue.inverse();
            return ExtraCodecs.idResolverCodec(p_388140_, arg_0 -> this.idToValue.get(arg_0), arg_0 -> $$1.get(arg_0));
        }

        public LateBoundIdMapper<I, V> put(I p_386862_, V p_387107_) {
            Objects.requireNonNull(p_387107_, () -> "Value for " + String.valueOf(p_386862_) + " is null");
            this.idToValue.put(p_386862_, p_387107_);
            return this;
        }
    }
}

