/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.StrictJsonParser;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ElementLookup<T> elementLookup;
    private final String directory;

    public TagLoader(ElementLookup<T> p_380077_, String p_144494_) {
        this.elementLookup = p_380077_;
        this.directory = p_144494_;
    }

    public Map<ResourceLocation, List<EntryWithSource>> load(ResourceManager p_144496_) {
        HashMap<ResourceLocation, List<EntryWithSource>> $$1 = new HashMap<ResourceLocation, List<EntryWithSource>>();
        FileToIdConverter $$2 = FileToIdConverter.json(this.directory);
        for (Map.Entry<ResourceLocation, List<Resource>> $$3 : $$2.listMatchingResourceStacks(p_144496_).entrySet()) {
            ResourceLocation $$4 = $$3.getKey();
            ResourceLocation $$5 = $$2.fileToId($$4);
            for (Resource $$6 : $$3.getValue()) {
                try {
                    BufferedReader $$7 = $$6.openAsReader();
                    try {
                        JsonElement $$8 = StrictJsonParser.parse($$7);
                        List $$9 = $$1.computeIfAbsent($$5, p_215974_ -> new ArrayList());
                        TagFile $$10 = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)$$8)).getOrThrow();
                        if ($$10.replace()) {
                            $$9.clear();
                        }
                        String $$11 = $$6.sourcePackId();
                        $$10.entries().forEach(p_215997_ -> $$9.add(new EntryWithSource((TagEntry)p_215997_, $$11)));
                    }
                    finally {
                        if ($$7 == null) continue;
                        ((Reader)$$7).close();
                    }
                }
                catch (Exception $$12) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{$$5, $$4, $$6.sourcePackId(), $$12});
                }
            }
        }
        return $$1;
    }

    private Either<List<EntryWithSource>, List<T>> tryBuildTag(TagEntry.Lookup<T> p_215979_, List<EntryWithSource> p_215980_) {
        LinkedHashSet $$2 = new LinkedHashSet();
        ArrayList<EntryWithSource> $$3 = new ArrayList<EntryWithSource>();
        for (EntryWithSource $$4 : p_215980_) {
            if ($$4.entry().build(p_215979_, $$2::add)) continue;
            $$3.add($$4);
        }
        return $$3.isEmpty() ? Either.right(List.copyOf($$2)) : Either.left($$3);
    }

    public Map<ResourceLocation, List<T>> build(Map<ResourceLocation, List<EntryWithSource>> p_203899_) {
        final HashMap $$1 = new HashMap();
        TagEntry.Lookup $$2 = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T element(ResourceLocation p_216039_, boolean p_380359_) {
                return TagLoader.this.elementLookup.get(p_216039_, p_380359_).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(ResourceLocation p_216041_) {
                return (Collection)$$1.get(p_216041_);
            }
        };
        DependencySorter<ResourceLocation, SortingEntry> $$3 = new DependencySorter<ResourceLocation, SortingEntry>();
        p_203899_.forEach((p_284685_, p_284686_) -> $$3.addEntry((ResourceLocation)p_284685_, new SortingEntry((List<EntryWithSource>)p_284686_)));
        $$3.orderByDependencies((p_359645_, p_359646_) -> this.tryBuildTag($$2, p_359646_.entries).ifLeft(p_359633_ -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", p_359645_, (Object)p_359633_.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(p_364232_ -> $$1.put((ResourceLocation)p_359645_, (List)p_364232_)));
        return $$1;
    }

    public static <T> void loadTagsFromNetwork(TagNetworkSerialization.NetworkPayload p_362324_, WritableRegistry<T> p_363626_) {
        p_362324_.resolve(p_363626_).tags.forEach(p_363626_::bindTag);
    }

    public static List<Registry.PendingTags<?>> loadTagsForExistingRegistries(ResourceManager p_362119_, RegistryAccess p_363563_) {
        return p_363563_.registries().map(p_359642_ -> TagLoader.loadPendingTags(p_362119_, p_359642_.value())).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public static <T> void loadTagsForRegistry(ResourceManager p_360949_, WritableRegistry<T> p_364371_) {
        ResourceKey $$2 = p_364371_.key();
        TagLoader<Holder<T>> $$3 = new TagLoader<Holder<T>>(ElementLookup.fromWritableRegistry(p_364371_), Registries.tagsDirPath($$2));
        $$3.build($$3.load(p_360949_)).forEach((p_359639_, p_359640_) -> p_364371_.bindTag(TagKey.create($$2, p_359639_), (List)p_359640_));
    }

    private static <T> Map<TagKey<T>, List<Holder<T>>> wrapTags(ResourceKey<? extends Registry<T>> p_365157_, Map<ResourceLocation, List<Holder<T>>> p_364335_) {
        return p_364335_.entrySet().stream().collect(Collectors.toUnmodifiableMap(p_359651_ -> TagKey.create(p_365157_, (ResourceLocation)p_359651_.getKey()), Map.Entry::getValue));
    }

    private static <T> Optional<Registry.PendingTags<T>> loadPendingTags(ResourceManager p_363343_, Registry<T> p_364997_) {
        ResourceKey<Registry<T>> $$2 = p_364997_.key();
        TagLoader<Holder<T>> $$3 = new TagLoader<Holder<T>>(ElementLookup.fromFrozenRegistry(p_364997_), Registries.tagsDirPath($$2));
        LoadResult<T> $$4 = new LoadResult<T>($$2, TagLoader.wrapTags(p_364997_.key(), $$3.build($$3.load(p_363343_))));
        return $$4.tags().isEmpty() ? Optional.empty() : Optional.of(p_364997_.prepareTagReload($$4));
    }

    public static List<HolderLookup.RegistryLookup<?>> buildUpdatedLookups(RegistryAccess.Frozen p_363335_, List<Registry.PendingTags<?>> p_364879_) {
        ArrayList $$2 = new ArrayList();
        p_363335_.registries().forEach(p_367916_ -> {
            Registry.PendingTags $$3 = TagLoader.findTagsForRegistry(p_364879_, p_367916_.key());
            $$2.add($$3 != null ? $$3.lookup() : p_367916_.value());
        });
        return $$2;
    }

    @Nullable
    private static Registry.PendingTags<?> findTagsForRegistry(List<Registry.PendingTags<?>> p_360320_, ResourceKey<? extends Registry<?>> p_360369_) {
        for (Registry.PendingTags<?> $$2 : p_360320_) {
            if ($$2.key() != p_360369_) continue;
            return $$2;
        }
        return null;
    }

    public static interface ElementLookup<T> {
        public Optional<? extends T> get(ResourceLocation var1, boolean var2);

        public static <T> ElementLookup<? extends Holder<T>> fromFrozenRegistry(Registry<T> p_379788_) {
            return (p_380205_, p_379703_) -> p_379788_.get(p_380205_);
        }

        public static <T> ElementLookup<Holder<T>> fromWritableRegistry(WritableRegistry<T> p_379984_) {
            HolderGetter $$1 = p_379984_.createRegistrationLookup();
            return (p_379723_, p_379675_) -> (p_379675_ ? $$1 : p_379984_).get(ResourceKey.create(p_379984_.key(), p_379723_));
        }
    }

    public record EntryWithSource(TagEntry entry, String source) {
        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    public record LoadResult<T>(ResourceKey<? extends Registry<T>> key, Map<TagKey<T>, List<Holder<T>>> tags) {
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> p_285529_) {
            this.entries.forEach(p_285236_ -> p_285236_.entry.visitRequiredDependencies(p_285529_));
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> p_285469_) {
            this.entries.forEach(p_284943_ -> p_284943_.entry.visitOptionalDependencies(p_285469_));
        }
    }
}

