/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.slf4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DisplayResolver displayResolver;
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> highlight = Sets.newIdentityHashSet();

    public ServerRecipeBook(DisplayResolver p_380166_) {
        this.displayResolver = p_380166_;
    }

    public void add(ResourceKey<Recipe<?>> p_379734_) {
        this.known.add(p_379734_);
    }

    public boolean contains(ResourceKey<Recipe<?>> p_379388_) {
        return this.known.contains(p_379388_);
    }

    public void remove(ResourceKey<Recipe<?>> p_380355_) {
        this.known.remove(p_380355_);
        this.highlight.remove(p_380355_);
    }

    public void removeHighlight(ResourceKey<Recipe<?>> p_380137_) {
        this.highlight.remove(p_380137_);
    }

    private void addHighlight(ResourceKey<Recipe<?>> p_379380_) {
        this.highlight.add(p_379380_);
    }

    public int addRecipes(Collection<RecipeHolder<?>> p_12792_, ServerPlayer p_12793_) {
        ArrayList<ClientboundRecipeBookAddPacket.Entry> $$2 = new ArrayList<ClientboundRecipeBookAddPacket.Entry>();
        for (RecipeHolder<?> $$3 : p_12792_) {
            ResourceKey<Recipe<?>> $$4 = $$3.id();
            if (this.known.contains($$4) || $$3.value().isSpecial()) continue;
            this.add($$4);
            this.addHighlight($$4);
            this.displayResolver.displaysForRecipe($$4, p_379913_ -> $$2.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)p_379913_, $$3.value().showNotification(), true)));
            CriteriaTriggers.RECIPE_UNLOCKED.trigger(p_12793_, $$3);
        }
        if (!$$2.isEmpty()) {
            p_12793_.connection.send(new ClientboundRecipeBookAddPacket($$2, false));
        }
        return $$2.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> p_12807_, ServerPlayer p_12808_) {
        ArrayList $$2 = Lists.newArrayList();
        for (RecipeHolder<?> $$3 : p_12807_) {
            ResourceKey<Recipe<?>> $$4 = $$3.id();
            if (!this.known.contains($$4)) continue;
            this.remove($$4);
            this.displayResolver.displaysForRecipe($$4, p_379363_ -> $$2.add(p_379363_.id()));
        }
        if (!$$2.isEmpty()) {
            p_12808_.connection.send(new ClientboundRecipeBookRemovePacket($$2));
        }
        return $$2.size();
    }

    private void loadRecipes(List<ResourceKey<Recipe<?>>> p_404832_, Consumer<ResourceKey<Recipe<?>>> p_12799_, Predicate<ResourceKey<Recipe<?>>> p_379754_) {
        for (ResourceKey<Recipe<?>> $$3 : p_404832_) {
            if (!p_379754_.test($$3)) {
                LOGGER.error("Tried to load unrecognized recipe: {} removed now.", $$3);
                continue;
            }
            p_12799_.accept($$3);
        }
    }

    public void sendInitialRecipeBook(ServerPlayer p_12790_) {
        p_12790_.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings().copy()));
        ArrayList<ClientboundRecipeBookAddPacket.Entry> $$1 = new ArrayList<ClientboundRecipeBookAddPacket.Entry>(this.known.size());
        for (ResourceKey<Recipe<?>> $$2 : this.known) {
            this.displayResolver.displaysForRecipe($$2, p_379992_ -> $$1.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)p_379992_, false, this.highlight.contains($$2))));
        }
        p_12790_.connection.send(new ClientboundRecipeBookAddPacket($$1, true));
    }

    public void copyOverData(ServerRecipeBook p_379645_) {
        this.apply(p_379645_.pack());
    }

    public Packed pack() {
        return new Packed(this.bookSettings.copy(), List.copyOf(this.known), List.copyOf(this.highlight));
    }

    private void apply(Packed p_422497_) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(p_422497_.settings);
        this.known.addAll(p_422497_.known);
        this.highlight.addAll(p_422497_.highlight);
    }

    public void loadUntrusted(Packed p_421546_, Predicate<ResourceKey<Recipe<?>>> p_422283_) {
        this.bookSettings.replaceFrom(p_421546_.settings);
        this.loadRecipes(p_421546_.known, this.known::add, p_422283_);
        this.loadRecipes(p_421546_.highlight, this.highlight::add, p_422283_);
    }

    @FunctionalInterface
    public static interface DisplayResolver {
        public void displaysForRecipe(ResourceKey<Recipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }

    public record Packed(RecipeBookSettings settings, List<ResourceKey<Recipe<?>>> known, List<ResourceKey<Recipe<?>>> highlight) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(p_422289_ -> p_422289_.group((App)RecipeBookSettings.MAP_CODEC.forGetter(Packed::settings), (App)Recipe.KEY_CODEC.listOf().fieldOf("recipes").forGetter(Packed::known), (App)Recipe.KEY_CODEC.listOf().fieldOf("toBeDisplayed").forGetter(Packed::highlight)).apply((Applicative)p_422289_, Packed::new));
    }
}

