/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientCredential;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.GsonHelper;

public class PlayerSafetyServiceTextFilter
extends ServerTextFilter {
    private final ConfidentialClientApplication client;
    private final ClientCredentialParameters clientParameters;
    private final Set<String> fullyFilteredEvents;
    private final int connectionReadTimeoutMs;

    private PlayerSafetyServiceTextFilter(URL p_364655_, ServerTextFilter.MessageEncoder p_363695_, ServerTextFilter.IgnoreStrategy p_364609_, ExecutorService p_362703_, ConfidentialClientApplication p_364360_, ClientCredentialParameters p_362037_, Set<String> p_361204_, int p_364088_) {
        super(p_364655_, p_363695_, p_364609_, p_362703_);
        this.client = p_364360_;
        this.clientParameters = p_362037_;
        this.fullyFilteredEvents = p_361204_;
        this.connectionReadTimeoutMs = p_364088_;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ServerTextFilter createTextFilterFromConfig(String p_364386_) {
        void $$29;
        void $$18;
        JsonObject $$1 = GsonHelper.parse(p_364386_);
        URI $$2 = URI.create(GsonHelper.getAsString($$1, "apiServer"));
        String $$3 = GsonHelper.getAsString($$1, "apiPath");
        String $$4 = GsonHelper.getAsString($$1, "scope");
        String $$5 = GsonHelper.getAsString($$1, "serverId", "");
        String $$6 = GsonHelper.getAsString($$1, "applicationId");
        String $$7 = GsonHelper.getAsString($$1, "tenantId");
        String $$8 = GsonHelper.getAsString($$1, "roomId", "Java:Chat");
        String $$9 = GsonHelper.getAsString($$1, "certificatePath");
        String $$10 = GsonHelper.getAsString($$1, "certificatePassword", "");
        int $$11 = GsonHelper.getAsInt($$1, "hashesToDrop", -1);
        int $$12 = GsonHelper.getAsInt($$1, "maxConcurrentRequests", 7);
        JsonArray $$13 = GsonHelper.getAsJsonArray($$1, "fullyFilteredEvents");
        HashSet<String> $$14 = new HashSet<String>();
        $$13.forEach(p_361597_ -> $$14.add(GsonHelper.convertToString(p_361597_, "filteredEvent")));
        int $$15 = GsonHelper.getAsInt($$1, "connectionReadTimeoutMs", 2000);
        try {
            URL $$16 = $$2.resolve($$3).toURL();
        }
        catch (MalformedURLException $$17) {
            throw new RuntimeException($$17);
        }
        ServerTextFilter.MessageEncoder $$19 = (p_360550_, p_361856_) -> {
            JsonObject $$4 = new JsonObject();
            $$4.addProperty("userId", p_360550_.getId().toString());
            $$4.addProperty("userDisplayName", p_360550_.getName());
            $$4.addProperty("server", $$5);
            $$4.addProperty("room", $$8);
            $$4.addProperty("area", "JavaChatRealms");
            $$4.addProperty("data", p_361856_);
            $$4.addProperty("language", "*");
            return $$4;
        };
        ServerTextFilter.IgnoreStrategy $$20 = ServerTextFilter.IgnoreStrategy.select($$11);
        ExecutorService $$21 = PlayerSafetyServiceTextFilter.createWorkerPool($$12);
        try (InputStream $$22 = Files.newInputStream(Path.of($$9, new String[0]), new OpenOption[0]);){
            IClientCertificate $$23 = ClientCredentialFactory.createFromCertificate((InputStream)$$22, (String)$$10);
        }
        catch (Exception $$25) {
            LOGGER.warn("Failed to open certificate file");
            return null;
        }
        try {
            void $$26;
            ConfidentialClientApplication $$27 = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)$$6, (IClientCredential)$$26).sendX5c(true).executorService($$21)).authority(String.format(Locale.ROOT, "https://login.microsoftonline.com/%s/", $$7))).build();
        }
        catch (Exception $$28) {
            LOGGER.warn("Failed to create confidential client application");
            return null;
        }
        ClientCredentialParameters $$30 = ClientCredentialParameters.builder(Set.of($$4)).build();
        return new PlayerSafetyServiceTextFilter((URL)$$18, $$19, $$20, $$21, (ConfidentialClientApplication)$$29, $$30, $$14, $$15);
    }

    private IAuthenticationResult aquireIAuthenticationResult() {
        return (IAuthenticationResult)this.client.acquireToken(this.clientParameters).join();
    }

    @Override
    protected void setAuthorizationProperty(HttpURLConnection p_364490_) {
        IAuthenticationResult $$1 = this.aquireIAuthenticationResult();
        p_364490_.setRequestProperty("Authorization", "Bearer " + $$1.accessToken());
    }

    @Override
    protected FilteredText filterText(String p_361948_, ServerTextFilter.IgnoreStrategy p_361780_, JsonObject p_364887_) {
        JsonObject $$3 = GsonHelper.getAsJsonObject(p_364887_, "result", null);
        if ($$3 == null) {
            return FilteredText.fullyFiltered(p_361948_);
        }
        boolean $$4 = GsonHelper.getAsBoolean($$3, "filtered", true);
        if (!$$4) {
            return FilteredText.passThrough(p_361948_);
        }
        JsonArray $$5 = GsonHelper.getAsJsonArray($$3, "events", new JsonArray());
        for (JsonElement $$6 : $$5) {
            JsonObject $$7 = $$6.getAsJsonObject();
            String $$8 = GsonHelper.getAsString($$7, "id", "");
            if (!this.fullyFilteredEvents.contains($$8)) continue;
            return FilteredText.fullyFiltered(p_361948_);
        }
        JsonArray $$9 = GsonHelper.getAsJsonArray($$3, "redactedTextIndex", new JsonArray());
        return new FilteredText(p_361948_, this.parseMask(p_361948_, $$9, p_361780_));
    }

    @Override
    protected int connectionReadTimeout() {
        return this.connectionReadTimeoutMs;
    }
}

