/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;

public class LegacyTextFilter
extends ServerTextFilter {
    private static final String ENDPOINT = "v1/chat";
    final URL joinEndpoint;
    final JoinOrLeaveEncoder joinEncoder;
    final URL leaveEndpoint;
    final JoinOrLeaveEncoder leaveEncoder;
    private final String authKey;

    private LegacyTextFilter(URL p_363560_, ServerTextFilter.MessageEncoder p_365315_, URL p_364476_, JoinOrLeaveEncoder p_360868_, URL p_365117_, JoinOrLeaveEncoder p_363479_, String p_364988_, ServerTextFilter.IgnoreStrategy p_364465_, ExecutorService p_365348_) {
        super(p_363560_, p_365315_, p_364465_, p_365348_);
        this.joinEndpoint = p_364476_;
        this.joinEncoder = p_360868_;
        this.leaveEndpoint = p_365117_;
        this.leaveEncoder = p_363479_;
        this.authKey = p_364988_;
    }

    @Nullable
    public static ServerTextFilter createTextFilterFromConfig(String p_363094_) {
        try {
            ServerTextFilter.MessageEncoder $$18;
            JsonObject $$1 = GsonHelper.parse(p_363094_);
            URI $$2 = new URI(GsonHelper.getAsString($$1, "apiServer"));
            String $$3 = GsonHelper.getAsString($$1, "apiKey");
            if ($$3.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int $$4 = GsonHelper.getAsInt($$1, "ruleId", 1);
            String $$5 = GsonHelper.getAsString($$1, "serverId", "");
            String $$6 = GsonHelper.getAsString($$1, "roomId", "Java:Chat");
            int $$7 = GsonHelper.getAsInt($$1, "hashesToDrop", -1);
            int $$8 = GsonHelper.getAsInt($$1, "maxConcurrentRequests", 7);
            JsonObject $$9 = GsonHelper.getAsJsonObject($$1, "endpoints", null);
            String $$10 = LegacyTextFilter.getEndpointFromConfig($$9, "chat", ENDPOINT);
            boolean $$11 = $$10.equals(ENDPOINT);
            URL $$12 = $$2.resolve("/" + $$10).toURL();
            URL $$13 = LegacyTextFilter.getEndpoint($$2, $$9, "join", "v1/join");
            URL $$14 = LegacyTextFilter.getEndpoint($$2, $$9, "leave", "v1/leave");
            JoinOrLeaveEncoder $$15 = p_363954_ -> {
                JsonObject $$3 = new JsonObject();
                $$3.addProperty("server", $$5);
                $$3.addProperty("room", $$6);
                $$3.addProperty("user_id", p_363954_.getId().toString());
                $$3.addProperty("user_display_name", p_363954_.getName());
                return $$3;
            };
            if ($$11) {
                ServerTextFilter.MessageEncoder $$16 = (p_363081_, p_365373_) -> {
                    JsonObject $$5 = new JsonObject();
                    $$5.addProperty("rule", (Number)$$4);
                    $$5.addProperty("server", $$5);
                    $$5.addProperty("room", $$6);
                    $$5.addProperty("player", p_363081_.getId().toString());
                    $$5.addProperty("player_display_name", p_363081_.getName());
                    $$5.addProperty("text", p_365373_);
                    $$5.addProperty("language", "*");
                    return $$5;
                };
            } else {
                String $$17 = String.valueOf($$4);
                $$18 = (p_365239_, p_360684_) -> {
                    JsonObject $$5 = new JsonObject();
                    $$5.addProperty("rule_id", $$17);
                    $$5.addProperty("category", $$5);
                    $$5.addProperty("subcategory", $$6);
                    $$5.addProperty("user_id", p_365239_.getId().toString());
                    $$5.addProperty("user_display_name", p_365239_.getName());
                    $$5.addProperty("text", p_360684_);
                    $$5.addProperty("language", "*");
                    return $$5;
                };
            }
            ServerTextFilter.IgnoreStrategy $$19 = ServerTextFilter.IgnoreStrategy.select($$7);
            ExecutorService $$20 = LegacyTextFilter.createWorkerPool($$8);
            String $$21 = Base64.getEncoder().encodeToString($$3.getBytes(StandardCharsets.US_ASCII));
            return new LegacyTextFilter($$12, $$18, $$13, $$15, $$14, $$15, $$21, $$19, $$20);
        }
        catch (Exception $$22) {
            LOGGER.warn("Failed to parse chat filter config {}", (Object)p_363094_, (Object)$$22);
            return null;
        }
    }

    @Override
    public TextFilter createContext(GameProfile p_364054_) {
        return new ServerTextFilter.PlayerContext(p_364054_){

            @Override
            public void join() {
                LegacyTextFilter.this.processJoinOrLeave(this.profile, LegacyTextFilter.this.joinEndpoint, LegacyTextFilter.this.joinEncoder, this.streamExecutor);
            }

            @Override
            public void leave() {
                LegacyTextFilter.this.processJoinOrLeave(this.profile, LegacyTextFilter.this.leaveEndpoint, LegacyTextFilter.this.leaveEncoder, this.streamExecutor);
            }
        };
    }

    void processJoinOrLeave(GameProfile p_364281_, URL p_364927_, JoinOrLeaveEncoder p_362293_, Executor p_363061_) {
        p_363061_.execute(() -> {
            JsonObject $$3 = p_362293_.encode(p_364281_);
            try {
                this.processRequest($$3, p_364927_);
            }
            catch (Exception $$4) {
                LOGGER.warn("Failed to send join/leave packet to {} for player {}", new Object[]{p_364927_, p_364281_, $$4});
            }
        });
    }

    private void processRequest(JsonObject p_364402_, URL p_360408_) throws IOException {
        HttpURLConnection $$2 = this.makeRequest(p_364402_, p_360408_);
        try (InputStream $$3 = $$2.getInputStream();){
            this.drainStream($$3);
        }
    }

    @Override
    protected void setAuthorizationProperty(HttpURLConnection p_365203_) {
        p_365203_.setRequestProperty("Authorization", "Basic " + this.authKey);
    }

    @Override
    protected FilteredText filterText(String p_361804_, ServerTextFilter.IgnoreStrategy p_362791_, JsonObject p_364399_) {
        boolean $$3 = GsonHelper.getAsBoolean(p_364399_, "response", false);
        if ($$3) {
            return FilteredText.passThrough(p_361804_);
        }
        String $$4 = GsonHelper.getAsString(p_364399_, "hashed", null);
        if ($$4 == null) {
            return FilteredText.fullyFiltered(p_361804_);
        }
        JsonArray $$5 = GsonHelper.getAsJsonArray(p_364399_, "hashes");
        FilterMask $$6 = this.parseMask(p_361804_, $$5, p_362791_);
        return new FilteredText(p_361804_, $$6);
    }

    @FunctionalInterface
    static interface JoinOrLeaveEncoder {
        public JsonObject encode(GameProfile var1);
    }
}

