/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> p_214731_, CommandBuildContext p_214732_) {
        Predicate<BlockInWorld> $$2 = p_180517_ -> p_180517_.getLevel().isEmptyBlock(p_180517_.getPos());
        p_214731_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(Commands.hasPermission(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block(p_214732_)).executes(p_392756_ -> SetBlockCommand.setBlock((CommandSourceStack)p_392756_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392756_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392756_, "block"), Mode.REPLACE, null, false))).then(Commands.literal("destroy").executes(p_392755_ -> SetBlockCommand.setBlock((CommandSourceStack)p_392755_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392755_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392755_, "block"), Mode.DESTROY, null, false)))).then(Commands.literal("keep").executes(p_392758_ -> SetBlockCommand.setBlock((CommandSourceStack)p_392758_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392758_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392758_, "block"), Mode.REPLACE, $$2, false)))).then(Commands.literal("replace").executes(p_392760_ -> SetBlockCommand.setBlock((CommandSourceStack)p_392760_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392760_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392760_, "block"), Mode.REPLACE, null, false)))).then(Commands.literal("strict").executes(p_392759_ -> SetBlockCommand.setBlock((CommandSourceStack)p_392759_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392759_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392759_, "block"), Mode.REPLACE, null, true))))));
    }

    private static int setBlock(CommandSourceStack p_138608_, BlockPos p_138609_, BlockInput p_138610_, Mode p_138611_, @Nullable Predicate<BlockInWorld> p_138612_, boolean p_393976_) throws CommandSyntaxException {
        boolean $$8;
        ServerLevel $$6 = p_138608_.getLevel();
        if ($$6.isDebug()) {
            throw ERROR_FAILED.create();
        }
        if (p_138612_ != null && !p_138612_.test(new BlockInWorld($$6, p_138609_, true))) {
            throw ERROR_FAILED.create();
        }
        if (p_138611_ == Mode.DESTROY) {
            $$6.destroyBlock(p_138609_, true);
            boolean $$7 = !p_138610_.getState().isAir() || !$$6.getBlockState(p_138609_).isAir();
        } else {
            $$8 = true;
        }
        BlockState $$9 = $$6.getBlockState(p_138609_);
        if ($$8 && !p_138610_.place($$6, p_138609_, 2 | (p_393976_ ? 816 : 256))) {
            throw ERROR_FAILED.create();
        }
        if (!p_393976_) {
            $$6.updateNeighboursOnBlockSet(p_138609_, $$9);
        }
        p_138608_.sendSuccess(() -> Component.translatable("commands.setblock.success", p_138609_.getX(), p_138609_.getY(), p_138609_.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }
}

