/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(p_304174_ -> Component.translatableEscape("commands.attribute.failed.entity", p_304174_));
    private static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ATTRIBUTE = new Dynamic2CommandExceptionType((p_304185_, p_304186_) -> Component.translatableEscape("commands.attribute.failed.no_attribute", p_304185_, p_304186_));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((p_304182_, p_304183_, p_304184_) -> Component.translatableEscape("commands.attribute.failed.no_modifier", p_304183_, p_304182_, p_304184_));
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((p_304187_, p_304188_, p_304189_) -> Component.translatableEscape("commands.attribute.failed.modifier_already_present", p_304189_, p_304188_, p_304187_));

    public static void register(CommandDispatcher<CommandSourceStack> p_251026_, CommandBuildContext p_250936_) {
        p_251026_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("attribute").requires(Commands.hasPermission(2))).then(Commands.argument("target", EntityArgument.entity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("attribute", ResourceArgument.resource(p_250936_, Registries.ATTRIBUTE)).then(((LiteralArgumentBuilder)Commands.literal("get").executes(p_248109_ -> AttributeCommand.getAttributeValue((CommandSourceStack)p_248109_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_248109_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_248109_, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_248104_ -> AttributeCommand.getAttributeValue((CommandSourceStack)p_248104_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_248104_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_248104_, "attribute"), DoubleArgumentType.getDouble((CommandContext)p_248104_, (String)"scale")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("base").then(Commands.literal("set").then(Commands.argument("value", DoubleArgumentType.doubleArg()).executes(p_248102_ -> AttributeCommand.setAttributeBase((CommandSourceStack)p_248102_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_248102_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_248102_, "attribute"), DoubleArgumentType.getDouble((CommandContext)p_248102_, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.literal("get").executes(p_248112_ -> AttributeCommand.getAttributeBase((CommandSourceStack)p_248112_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_248112_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_248112_, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_248106_ -> AttributeCommand.getAttributeBase((CommandSourceStack)p_248106_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_248106_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_248106_, "attribute"), DoubleArgumentType.getDouble((CommandContext)p_248106_, (String)"scale")))))).then(Commands.literal("reset").executes(p_382664_ -> AttributeCommand.resetAttributeBase((CommandSourceStack)p_382664_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_382664_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_382664_, "attribute")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("modifier").then(Commands.literal("add").then(Commands.argument("id", ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("value", DoubleArgumentType.doubleArg()).then(Commands.literal("add_value").executes(p_349940_ -> AttributeCommand.addModifier((CommandSourceStack)p_349940_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_349940_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_349940_, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_349940_, "id"), DoubleArgumentType.getDouble((CommandContext)p_349940_, (String)"value"), AttributeModifier.Operation.ADD_VALUE)))).then(Commands.literal("add_multiplied_base").executes(p_349930_ -> AttributeCommand.addModifier((CommandSourceStack)p_349930_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_349930_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_349930_, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_349930_, "id"), DoubleArgumentType.getDouble((CommandContext)p_349930_, (String)"value"), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).then(Commands.literal("add_multiplied_total").executes(p_349945_ -> AttributeCommand.addModifier((CommandSourceStack)p_349945_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_349945_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_349945_, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_349945_, "id"), DoubleArgumentType.getDouble((CommandContext)p_349945_, (String)"value"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))))))).then(Commands.literal("remove").then(Commands.argument("id", ResourceLocationArgument.id()).suggests((p_382668_, p_382669_) -> SharedSuggestionProvider.suggestResource(AttributeCommand.getAttributeModifiers(EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_382668_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_382668_, "attribute")), p_382669_)).executes(p_349938_ -> AttributeCommand.removeModifier((CommandSourceStack)p_349938_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_349938_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_349938_, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_349938_, "id")))))).then(Commands.literal("value").then(Commands.literal("get").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests((p_382670_, p_382671_) -> SharedSuggestionProvider.suggestResource(AttributeCommand.getAttributeModifiers(EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_382670_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_382670_, "attribute")), p_382671_)).executes(p_349941_ -> AttributeCommand.getAttributeModifier((CommandSourceStack)p_349941_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_349941_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_349941_, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_349941_, "id"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_349939_ -> AttributeCommand.getAttributeModifier((CommandSourceStack)p_349939_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_349939_, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)p_349939_, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_349939_, "id"), DoubleArgumentType.getDouble((CommandContext)p_349939_, (String)"scale")))))))))));
    }

    private static AttributeInstance getAttributeInstance(Entity p_252177_, Holder<Attribute> p_249942_) throws CommandSyntaxException {
        AttributeInstance $$2 = AttributeCommand.getLivingEntity(p_252177_).getAttributes().getInstance(p_249942_);
        if ($$2 == null) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)p_252177_.getName(), (Object)AttributeCommand.getAttributeDescription(p_249942_));
        }
        return $$2;
    }

    private static LivingEntity getLivingEntity(Entity p_136440_) throws CommandSyntaxException {
        if (!(p_136440_ instanceof LivingEntity)) {
            throw ERROR_NOT_LIVING_ENTITY.create((Object)p_136440_.getName());
        }
        return (LivingEntity)p_136440_;
    }

    private static LivingEntity getEntityWithAttribute(Entity p_252105_, Holder<Attribute> p_248921_) throws CommandSyntaxException {
        LivingEntity $$2 = AttributeCommand.getLivingEntity(p_252105_);
        if (!$$2.getAttributes().hasAttribute(p_248921_)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)p_252105_.getName(), (Object)AttributeCommand.getAttributeDescription(p_248921_));
        }
        return $$2;
    }

    private static int getAttributeValue(CommandSourceStack p_251776_, Entity p_249647_, Holder<Attribute> p_250986_, double p_251395_) throws CommandSyntaxException {
        LivingEntity $$4 = AttributeCommand.getEntityWithAttribute(p_249647_, p_250986_);
        double $$5 = $$4.getAttributeValue(p_250986_);
        p_251776_.sendSuccess(() -> Component.translatable("commands.attribute.value.get.success", AttributeCommand.getAttributeDescription(p_250986_), p_249647_.getName(), $$5), false);
        return (int)($$5 * p_251395_);
    }

    private static int getAttributeBase(CommandSourceStack p_248780_, Entity p_251083_, Holder<Attribute> p_250388_, double p_250194_) throws CommandSyntaxException {
        LivingEntity $$4 = AttributeCommand.getEntityWithAttribute(p_251083_, p_250388_);
        double $$5 = $$4.getAttributeBaseValue(p_250388_);
        p_248780_.sendSuccess(() -> Component.translatable("commands.attribute.base_value.get.success", AttributeCommand.getAttributeDescription(p_250388_), p_251083_.getName(), $$5), false);
        return (int)($$5 * p_250194_);
    }

    private static int getAttributeModifier(CommandSourceStack p_136464_, Entity p_136465_, Holder<Attribute> p_250680_, ResourceLocation p_350277_, double p_136468_) throws CommandSyntaxException {
        LivingEntity $$5 = AttributeCommand.getEntityWithAttribute(p_136465_, p_250680_);
        AttributeMap $$6 = $$5.getAttributes();
        if (!$$6.hasModifier(p_250680_, p_350277_)) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)p_136465_.getName(), (Object)AttributeCommand.getAttributeDescription(p_250680_), (Object)p_350277_);
        }
        double $$7 = $$6.getModifierValue(p_250680_, p_350277_);
        p_136464_.sendSuccess(() -> Component.translatable("commands.attribute.modifier.value.get.success", Component.translationArg(p_350277_), AttributeCommand.getAttributeDescription(p_250680_), p_136465_.getName(), $$7), false);
        return (int)($$7 * p_136468_);
    }

    private static Stream<ResourceLocation> getAttributeModifiers(Entity p_382972_, Holder<Attribute> p_383129_) throws CommandSyntaxException {
        AttributeInstance $$2 = AttributeCommand.getAttributeInstance(p_382972_, p_383129_);
        return $$2.getModifiers().stream().map(AttributeModifier::id);
    }

    private static int setAttributeBase(CommandSourceStack p_248556_, Entity p_248620_, Holder<Attribute> p_249456_, double p_252212_) throws CommandSyntaxException {
        AttributeCommand.getAttributeInstance(p_248620_, p_249456_).setBaseValue(p_252212_);
        p_248556_.sendSuccess(() -> Component.translatable("commands.attribute.base_value.set.success", AttributeCommand.getAttributeDescription(p_249456_), p_248620_.getName(), p_252212_), false);
        return 1;
    }

    private static int resetAttributeBase(CommandSourceStack p_383106_, Entity p_382924_, Holder<Attribute> p_382828_) throws CommandSyntaxException {
        LivingEntity $$3 = AttributeCommand.getLivingEntity(p_382924_);
        if (!$$3.getAttributes().resetBaseValue(p_382828_)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)p_382924_.getName(), (Object)AttributeCommand.getAttributeDescription(p_382828_));
        }
        double $$4 = $$3.getAttributeBaseValue(p_382828_);
        p_383106_.sendSuccess(() -> Component.translatable("commands.attribute.base_value.reset.success", AttributeCommand.getAttributeDescription(p_382828_), p_382924_.getName(), $$4), false);
        return 1;
    }

    private static int addModifier(CommandSourceStack p_136470_, Entity p_136471_, Holder<Attribute> p_251636_, ResourceLocation p_350414_, double p_136475_, AttributeModifier.Operation p_136476_) throws CommandSyntaxException {
        AttributeInstance $$6 = AttributeCommand.getAttributeInstance(p_136471_, p_251636_);
        AttributeModifier $$7 = new AttributeModifier(p_350414_, p_136475_, p_136476_);
        if ($$6.hasModifier(p_350414_)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)p_136471_.getName(), (Object)AttributeCommand.getAttributeDescription(p_251636_), (Object)p_350414_);
        }
        $$6.addPermanentModifier($$7);
        p_136470_.sendSuccess(() -> Component.translatable("commands.attribute.modifier.add.success", Component.translationArg(p_350414_), AttributeCommand.getAttributeDescription(p_251636_), p_136471_.getName()), false);
        return 1;
    }

    private static int removeModifier(CommandSourceStack p_136459_, Entity p_136460_, Holder<Attribute> p_250830_, ResourceLocation p_350686_) throws CommandSyntaxException {
        AttributeInstance $$4 = AttributeCommand.getAttributeInstance(p_136460_, p_250830_);
        if ($$4.removeModifier(p_350686_)) {
            p_136459_.sendSuccess(() -> Component.translatable("commands.attribute.modifier.remove.success", Component.translationArg(p_350686_), AttributeCommand.getAttributeDescription(p_250830_), p_136460_.getName()), false);
            return 1;
        }
        throw ERROR_NO_SUCH_MODIFIER.create((Object)p_136460_.getName(), (Object)AttributeCommand.getAttributeDescription(p_250830_), (Object)p_350686_);
    }

    private static Component getAttributeDescription(Holder<Attribute> p_250602_) {
        return Component.translatable(p_250602_.value().getDescriptionId());
    }
}

