/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class CustomBossEvent
extends ServerBossEvent {
    private static final int DEFAULT_MAX = 100;
    private final ResourceLocation id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;

    public CustomBossEvent(ResourceLocation p_136261_, Component p_136262_) {
        super(p_136262_, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.id = p_136261_;
        this.setProgress(0.0f);
    }

    public ResourceLocation getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(ServerPlayer p_136267_) {
        super.addPlayer(p_136267_);
        this.players.add(p_136267_.getUUID());
    }

    public void addOfflinePlayer(UUID p_136271_) {
        this.players.add(p_136271_);
    }

    @Override
    public void removePlayer(ServerPlayer p_136281_) {
        super.removePlayer(p_136281_);
        this.players.remove(p_136281_.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int p_136265_) {
        this.value = p_136265_;
        this.setProgress(Mth.clamp((float)p_136265_ / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int p_136279_) {
        this.max = p_136279_;
        this.setProgress(Mth.clamp((float)this.value / (float)p_136279_, 0.0f, 1.0f));
    }

    public final Component getDisplayName() {
        return ComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(p_404184_ -> p_404184_.withColor(this.getColor().getFormatting()).withHoverEvent(new HoverEvent.ShowText(Component.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<ServerPlayer> p_136269_) {
        HashSet $$1 = Sets.newHashSet();
        HashSet $$2 = Sets.newHashSet();
        for (UUID $$3 : this.players) {
            boolean $$4 = false;
            for (ServerPlayer $$5 : p_136269_) {
                if (!$$5.getUUID().equals($$3)) continue;
                $$4 = true;
                break;
            }
            if ($$4) continue;
            $$1.add($$3);
        }
        for (ServerPlayer $$6 : p_136269_) {
            boolean $$7 = false;
            for (UUID $$8 : this.players) {
                if (!$$6.getUUID().equals($$8)) continue;
                $$7 = true;
                break;
            }
            if ($$7) continue;
            $$2.add($$6);
        }
        for (UUID $$9 : $$1) {
            for (ServerPlayer $$10 : this.getPlayers()) {
                if (!$$10.getUUID().equals($$9)) continue;
                this.removePlayer($$10);
                break;
            }
            this.players.remove($$9);
        }
        for (ServerPlayer $$11 : $$2) {
            this.addPlayer($$11);
        }
        return !$$1.isEmpty() || !$$2.isEmpty();
    }

    public static CustomBossEvent load(ResourceLocation p_136274_, Packed p_405765_) {
        CustomBossEvent $$2 = new CustomBossEvent(p_136274_, p_405765_.name);
        $$2.setVisible(p_405765_.visible);
        $$2.setValue(p_405765_.value);
        $$2.setMax(p_405765_.max);
        $$2.setColor(p_405765_.color);
        $$2.setOverlay(p_405765_.overlay);
        $$2.setDarkenScreen(p_405765_.darkenScreen);
        $$2.setPlayBossMusic(p_405765_.playBossMusic);
        $$2.setCreateWorldFog(p_405765_.createWorldFog);
        p_405765_.players.forEach($$2::addOfflinePlayer);
        return $$2;
    }

    public Packed pack() {
        return new Packed(this.getName(), this.isVisible(), this.getValue(), this.getMax(), this.getColor(), this.getOverlay(), this.shouldDarkenScreen(), this.shouldPlayBossMusic(), this.shouldCreateWorldFog(), Set.copyOf(this.players));
    }

    public void onPlayerConnect(ServerPlayer p_136284_) {
        if (this.players.contains(p_136284_.getUUID())) {
            this.addPlayer(p_136284_);
        }
    }

    public void onPlayerDisconnect(ServerPlayer p_136287_) {
        super.removePlayer(p_136287_);
    }

    public record Packed(Component name, boolean visible, int value, int max, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog, Set<UUID> players) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(p_405289_ -> p_405289_.group((App)ComponentSerialization.CODEC.fieldOf("Name").forGetter(Packed::name), (App)Codec.BOOL.optionalFieldOf("Visible", (Object)false).forGetter(Packed::visible), (App)Codec.INT.optionalFieldOf("Value", (Object)0).forGetter(Packed::value), (App)Codec.INT.optionalFieldOf("Max", (Object)100).forGetter(Packed::max), (App)BossEvent.BossBarColor.CODEC.optionalFieldOf("Color", (Object)BossEvent.BossBarColor.WHITE).forGetter(Packed::color), (App)BossEvent.BossBarOverlay.CODEC.optionalFieldOf("Overlay", (Object)BossEvent.BossBarOverlay.PROGRESS).forGetter(Packed::overlay), (App)Codec.BOOL.optionalFieldOf("DarkenScreen", (Object)false).forGetter(Packed::darkenScreen), (App)Codec.BOOL.optionalFieldOf("PlayBossMusic", (Object)false).forGetter(Packed::playBossMusic), (App)Codec.BOOL.optionalFieldOf("CreateWorldFog", (Object)false).forGetter(Packed::createWorldFog), (App)UUIDUtil.CODEC_SET.optionalFieldOf("Players", Set.of()).forGetter(Packed::players)).apply((Applicative)p_405289_, Packed::new));
    }
}

