/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<Holder<E>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Holder<E>> p_206668_, boolean p_206669_) {
        Codec $$2 = p_206668_.listOf().validate(ExtraCodecs.ensureHomogenous(Holder::kind));
        if (p_206669_) {
            return $$2;
        }
        return ExtraCodecs.compactListCodec(p_206668_, $$2);
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends Registry<E>> p_206686_, Codec<Holder<E>> p_206687_, boolean p_206688_) {
        return new HolderSetCodec<E>(p_206686_, p_206687_, p_206688_);
    }

    private HolderSetCodec(ResourceKey<? extends Registry<E>> p_206660_, Codec<Holder<E>> p_206661_, boolean p_206662_) {
        this.registryKey = p_206660_;
        this.elementCodec = p_206661_;
        this.homogenousListCodec = HolderSetCodec.homogenousList(p_206661_, p_206662_);
        this.registryAwareCodec = Codec.either(TagKey.hashedCodec(p_206660_), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> p_206696_, T p_206697_) {
        RegistryOps $$2;
        Optional $$3;
        if (p_206696_ instanceof RegistryOps && ($$3 = ($$2 = (RegistryOps)p_206696_).getter(this.registryKey)).isPresent()) {
            HolderGetter $$4 = $$3.get();
            return this.registryAwareCodec.decode(p_206696_, p_206697_).flatMap(p_337522_ -> {
                DataResult $$2 = (DataResult)((Either)p_337522_.getFirst()).map(p_332559_ -> HolderSetCodec.lookupTag($$4, p_332559_), p_332564_ -> DataResult.success(HolderSet.direct(p_332564_)));
                return $$2.map(p_332563_ -> Pair.of((Object)p_332563_, (Object)p_337522_.getSecond()));
            });
        }
        return this.decodeWithoutRegistry(p_206696_, p_206697_);
    }

    private static <E> DataResult<HolderSet<E>> lookupTag(HolderGetter<E> p_332757_, TagKey<E> p_332743_) {
        return p_332757_.get(p_332743_).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(p_332743_.location()) + "' in '" + String.valueOf(p_332743_.registry().location()) + "'"));
    }

    public <T> DataResult<T> encode(HolderSet<E> p_206674_, DynamicOps<T> p_206675_, T p_206676_) {
        RegistryOps $$3;
        Optional $$4;
        if (p_206675_ instanceof RegistryOps && ($$4 = ($$3 = (RegistryOps)p_206675_).owner(this.registryKey)).isPresent()) {
            if (!p_206674_.canSerializeIn($$4.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(p_206674_) + " is not valid in current registry set");
            }
            return this.registryAwareCodec.encode((Object)p_206674_.unwrap().mapRight(List::copyOf), p_206675_, p_206676_);
        }
        return this.encodeWithoutRegistry(p_206674_, p_206675_, p_206676_);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> p_206671_, T p_206672_) {
        return this.elementCodec.listOf().decode(p_206671_, p_206672_).flatMap(p_206666_ -> {
            ArrayList<Holder.Direct> $$1 = new ArrayList<Holder.Direct>();
            for (Holder $$2 : (List)p_206666_.getFirst()) {
                if ($$2 instanceof Holder.Direct) {
                    Holder.Direct $$3 = (Holder.Direct)$$2;
                    $$1.add($$3);
                    continue;
                }
                return DataResult.error(() -> "Can't decode element " + String.valueOf($$2) + " without registry");
            }
            return DataResult.success((Object)new Pair(HolderSet.direct($$1), p_206666_.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> p_206690_, DynamicOps<T> p_206691_, T p_206692_) {
        return this.homogenousListCodec.encode(p_206690_.stream().toList(), p_206691_, p_206692_);
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((HolderSet)object, dynamicOps, object2);
    }
}

