/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.RedstoneWireOrientationsDebugPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class DebugPackets {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void sendGameTestAddMarker(ServerLevel p_133683_, BlockPos p_133684_, String p_133685_, int p_133686_, int p_133687_) {
        DebugPackets.sendPacketToAllPlayers(p_133683_, new GameTestAddMarkerDebugPayload(p_133684_, p_133686_, p_133685_, p_133687_));
    }

    public static void sendGameTestClearPacket(ServerLevel p_133675_) {
        DebugPackets.sendPacketToAllPlayers(p_133675_, new GameTestClearMarkersDebugPayload());
    }

    public static void sendPoiPacketsForChunk(ServerLevel p_133677_, ChunkPos p_133678_) {
    }

    public static void sendPoiAddedPacket(ServerLevel p_133680_, BlockPos p_133681_) {
        DebugPackets.sendVillageSectionsPacket(p_133680_, p_133681_);
    }

    public static void sendPoiRemovedPacket(ServerLevel p_133717_, BlockPos p_133718_) {
        DebugPackets.sendVillageSectionsPacket(p_133717_, p_133718_);
    }

    public static void sendPoiTicketCountPacket(ServerLevel p_133720_, BlockPos p_133721_) {
        DebugPackets.sendVillageSectionsPacket(p_133720_, p_133721_);
    }

    private static void sendVillageSectionsPacket(ServerLevel p_133723_, BlockPos p_133724_) {
    }

    public static void sendPathFindingPacket(Level p_133704_, Mob p_133705_, @Nullable Path p_133706_, float p_133707_) {
    }

    public static void sendNeighborsUpdatePacket(Level p_133709_, BlockPos p_133710_) {
    }

    public static void sendWireUpdates(Level p_360724_, RedstoneWireOrientationsDebugPayload p_365329_) {
        if (p_360724_ instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)p_360724_;
            DebugPackets.sendPacketToAllPlayers($$2, p_365329_);
        }
    }

    public static void sendStructurePacket(WorldGenLevel p_133712_, StructureStart p_133713_) {
    }

    public static void sendGoalSelector(Level p_133700_, Mob p_133701_, GoalSelector p_133702_) {
    }

    public static void sendRaids(ServerLevel p_133689_, Collection<Raid> p_133690_) {
    }

    public static void sendEntityBrain(LivingEntity p_133696_) {
    }

    public static void sendBeeInfo(Bee p_133698_) {
    }

    public static void sendBreezeInfo(Breeze p_312299_) {
    }

    public static void sendGameEventInfo(Level p_237888_, Holder<GameEvent> p_316607_, Vec3 p_237890_) {
    }

    public static void sendGameEventListenerInfo(Level p_179508_, GameEventListener p_179509_) {
    }

    public static void sendHiveInfo(Level p_179511_, BlockPos p_179512_, BlockState p_179513_, BeehiveBlockEntity p_179514_) {
    }

    private static List<String> getMemoryDescriptions(LivingEntity p_179496_, long p_179497_) {
        Map<MemoryModuleType<?>, Optional<ExpirableValue<?>>> $$2 = p_179496_.getBrain().getMemories();
        ArrayList $$3 = Lists.newArrayList();
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> $$4 : $$2.entrySet()) {
            String $$13;
            MemoryModuleType<?> $$5 = $$4.getKey();
            Optional<ExpirableValue<?>> $$6 = $$4.getValue();
            if ($$6.isPresent()) {
                ExpirableValue<?> $$7 = $$6.get();
                Object $$8 = $$7.getValue();
                if ($$5 == MemoryModuleType.HEARD_BELL_TIME) {
                    long $$9 = p_179497_ - (Long)$$8;
                    String $$10 = $$9 + " ticks ago";
                } else if ($$7.canExpire()) {
                    String $$11 = DebugPackets.getShortDescription((ServerLevel)p_179496_.level(), $$8) + " (ttl: " + $$7.getTimeToLive() + ")";
                } else {
                    String $$12 = DebugPackets.getShortDescription((ServerLevel)p_179496_.level(), $$8);
                }
            } else {
                $$13 = "-";
            }
            $$3.add(BuiltInRegistries.MEMORY_MODULE_TYPE.getKey($$5).getPath() + ": " + $$13);
        }
        $$3.sort(String::compareTo);
        return $$3;
    }

    private static String getShortDescription(ServerLevel p_179493_, @Nullable Object p_179494_) {
        if (p_179494_ == null) {
            return "-";
        }
        if (p_179494_ instanceof UUID) {
            return DebugPackets.getShortDescription(p_179493_, p_179493_.getEntity((UUID)p_179494_));
        }
        if (p_179494_ instanceof LivingEntity) {
            Entity $$2 = (Entity)p_179494_;
            return DebugEntityNameGenerator.getEntityName($$2);
        }
        if (p_179494_ instanceof Nameable) {
            return ((Nameable)p_179494_).getName().getString();
        }
        if (p_179494_ instanceof WalkTarget) {
            return DebugPackets.getShortDescription(p_179493_, ((WalkTarget)p_179494_).getTarget());
        }
        if (p_179494_ instanceof EntityTracker) {
            return DebugPackets.getShortDescription(p_179493_, ((EntityTracker)p_179494_).getEntity());
        }
        if (p_179494_ instanceof GlobalPos) {
            return DebugPackets.getShortDescription(p_179493_, ((GlobalPos)p_179494_).pos());
        }
        if (p_179494_ instanceof BlockPosTracker) {
            return DebugPackets.getShortDescription(p_179493_, ((BlockPosTracker)p_179494_).currentBlockPosition());
        }
        if (p_179494_ instanceof DamageSource) {
            Entity $$3 = ((DamageSource)p_179494_).getEntity();
            return $$3 == null ? p_179494_.toString() : DebugPackets.getShortDescription(p_179493_, $$3);
        }
        if (p_179494_ instanceof Collection) {
            ArrayList $$4 = Lists.newArrayList();
            for (Object $$5 : (Iterable)p_179494_) {
                $$4.add(DebugPackets.getShortDescription(p_179493_, $$5));
            }
            return ((Object)$$4).toString();
        }
        return p_179494_.toString();
    }

    private static void sendPacketToAllPlayers(ServerLevel p_133692_, CustomPacketPayload p_296119_) {
        ClientboundCustomPayloadPacket $$2 = new ClientboundCustomPayloadPacket(p_296119_);
        for (ServerPlayer $$3 : p_133692_.players()) {
            $$3.connection.send($$2);
        }
    }

    private static /* synthetic */ void lambda$sendGameEventInfo$7(ServerLevel p_315898_, Vec3 p_315899_, ResourceKey p_315900_) {
        DebugPackets.sendPacketToAllPlayers(p_315898_, new GameEventDebugPayload(p_315900_, p_315899_));
    }

    private static /* synthetic */ void lambda$sendEntityBrain$6(List p_237899_, UUID p_237900_, Object2IntMap p_237901_) {
        String $$3 = DebugEntityNameGenerator.getEntityName(p_237900_);
        p_237901_.forEach((p_339416_, p_339417_) -> p_237899_.add($$3 + ": " + String.valueOf(p_339416_) + ": " + p_339417_));
    }

    private static /* synthetic */ String lambda$sendEntityBrain$4(String p_293743_) {
        return StringUtil.truncateStringIfNecessary(p_293743_, 255, true);
    }

    private static /* synthetic */ void lambda$sendGoalSelector$3(List p_293744_, WrappedGoal p_293745_) {
        p_293744_.add(new GoalDebugPayload.DebugGoal(p_293745_.getPriority(), p_293745_.isRunning(), p_293745_.getGoal().getClass().getSimpleName()));
    }

    private static /* synthetic */ String lambda$sendPoiAddedPacket$2(ResourceKey p_237886_) {
        return p_237886_.location().toString();
    }

    private static /* synthetic */ void lambda$sendPoiPacketsForChunk$1(ServerLevel p_179490_, PoiRecord p_179491_) {
        DebugPackets.sendPoiAddedPacket(p_179490_, p_179491_.getPos());
    }

    private static /* synthetic */ boolean lambda$sendPoiPacketsForChunk$0(Holder p_237892_) {
        return true;
    }
}

