/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public Boolean decode(ByteBuf p_320813_) {
            return p_320813_.readBoolean();
        }

        @Override
        public void encode(ByteBuf p_319896_, Boolean p_320251_) {
            p_319896_.writeBoolean(p_320251_.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Boolean)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public Byte decode(ByteBuf p_320628_) {
            return p_320628_.readByte();
        }

        @Override
        public void encode(ByteBuf p_320364_, Byte p_320618_) {
            p_320364_.writeByte((int)p_320618_.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Byte)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> ROTATION_BYTE = BYTE.map(Mth::unpackDegrees, Mth::packDegrees);
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        @Override
        public Short decode(ByteBuf p_320513_) {
            return p_320513_.readShort();
        }

        @Override
        public void encode(ByteBuf p_320028_, Short p_320388_) {
            p_320028_.writeShort((int)p_320388_.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Short)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf p_320319_) {
            return p_320319_.readUnsignedShort();
        }

        @Override
        public void encode(ByteBuf p_320669_, Integer p_320205_) {
            p_320669_.writeShort(p_320205_.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf p_320253_) {
            return p_320253_.readInt();
        }

        @Override
        public void encode(ByteBuf p_320753_, Integer p_330380_) {
            p_320753_.writeInt(p_330380_.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf p_320759_) {
            return VarInt.read(p_320759_);
        }

        @Override
        public void encode(ByteBuf p_320314_, Integer p_341414_) {
            VarInt.write(p_320314_, p_341414_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_VAR_INT = VAR_INT.map(p_378955_ -> p_378955_ == 0 ? OptionalInt.empty() : OptionalInt.of(p_378955_ - 1), p_378954_ -> p_378954_.isPresent() ? p_378954_.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf p_320635_) {
            return p_320635_.readLong();
        }

        @Override
        public void encode(ByteBuf p_320545_, Long p_341419_) {
            p_320545_.writeLong(p_341419_.longValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf p_320259_) {
            return VarLong.read(p_320259_);
        }

        @Override
        public void encode(ByteBuf p_320199_, Long p_376100_) {
            VarLong.write(p_320199_, p_376100_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        public Float decode(ByteBuf p_320599_) {
            return Float.valueOf(p_320599_.readFloat());
        }

        @Override
        public void encode(ByteBuf p_320880_, Float p_376495_) {
            p_320880_.writeFloat(p_376495_.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Float)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        public Double decode(ByteBuf p_319947_) {
            return p_319947_.readDouble();
        }

        @Override
        public void encode(ByteBuf p_320370_, Double p_376267_) {
            p_320370_.writeDouble(p_376267_.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Double)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        @Override
        public byte[] decode(ByteBuf p_332176_) {
            return FriendlyByteBuf.readByteArray(p_332176_);
        }

        @Override
        public void encode(ByteBuf p_331068_, byte[] p_376625_) {
            FriendlyByteBuf.writeByteArray(p_331068_, p_376625_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (byte[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, long[]> LONG_ARRAY = new StreamCodec<ByteBuf, long[]>(){

        @Override
        public long[] decode(ByteBuf p_341393_) {
            return FriendlyByteBuf.readLongArray(p_341393_);
        }

        @Override
        public void encode(ByteBuf p_340857_, long[] p_404761_) {
            FriendlyByteBuf.writeLongArray(p_340857_, p_404761_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (long[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Tag> TAG = ByteBufCodecs.tagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, Tag> TRUSTED_TAG = ByteBufCodecs.tagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, CompoundTag> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<CompoundTag>>(){

        @Override
        public Optional<CompoundTag> decode(ByteBuf p_324220_) {
            return Optional.ofNullable(FriendlyByteBuf.readNbt(p_324220_));
        }

        @Override
        public void encode(ByteBuf p_323874_, Optional<CompoundTag> p_428393_) {
            FriendlyByteBuf.writeNbt(p_323874_, p_428393_.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Optional)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> VECTOR3F = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        public Vector3f decode(ByteBuf p_331901_) {
            return FriendlyByteBuf.readVector3f(p_331901_);
        }

        @Override
        public void encode(ByteBuf p_331539_, Vector3f p_428266_) {
            FriendlyByteBuf.writeVector3f(p_331539_, p_428266_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vector3f)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionf>(){

        @Override
        public Quaternionf decode(ByteBuf p_332082_) {
            return FriendlyByteBuf.readQuaternion(p_332082_);
        }

        @Override
        public void encode(ByteBuf p_331172_, Quaternionf p_428267_) {
            FriendlyByteBuf.writeQuaternion(p_331172_, p_428267_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Quaternionf)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> CONTAINER_ID = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf p_340809_) {
            return FriendlyByteBuf.readContainerId(p_340809_);
        }

        @Override
        public void encode(ByteBuf p_341417_, Integer p_428195_) {
            FriendlyByteBuf.writeContainerId(p_341417_, p_428195_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int MAX_PROPERTY_NAME_LENGTH = 64;
        private static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
        private static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
        private static final int MAX_PROPERTIES = 16;

        @Override
        public PropertyMap decode(ByteBuf p_415628_) {
            int $$1 = ByteBufCodecs.readCount(p_415628_, 16);
            PropertyMap $$2 = new PropertyMap();
            for (int $$3 = 0; $$3 < $$1; ++$$3) {
                String $$4 = Utf8String.read(p_415628_, 64);
                String $$5 = Utf8String.read(p_415628_, Short.MAX_VALUE);
                String $$6 = FriendlyByteBuf.readNullable(p_415628_, p_428194_ -> Utf8String.read(p_428194_, 1024));
                Property $$7 = new Property($$4, $$5, $$6);
                $$2.put((Object)$$7.name(), (Object)$$7);
            }
            return $$2;
        }

        @Override
        public void encode(ByteBuf p_415915_, PropertyMap p_428306_) {
            ByteBufCodecs.writeCount(p_415915_, p_428306_.size(), 16);
            for (Property $$2 : p_428306_.values()) {
                Utf8String.write(p_415915_, $$2.name(), 64);
                Utf8String.write(p_415915_, $$2.value(), Short.MAX_VALUE);
                FriendlyByteBuf.writeNullable(p_415915_, $$2.signature(), (p_428520_, p_428307_) -> Utf8String.write(p_428520_, p_428307_, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (PropertyMap)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = new StreamCodec<ByteBuf, GameProfile>(){

        @Override
        public GameProfile decode(ByteBuf p_422404_) {
            UUID $$1 = (UUID)UUIDUtil.STREAM_CODEC.decode(p_422404_);
            String $$2 = Utf8String.read(p_422404_, 16);
            GameProfile $$3 = new GameProfile($$1, $$2);
            $$3.getProperties().putAll((Multimap)GAME_PROFILE_PROPERTIES.decode(p_422404_));
            return $$3;
        }

        @Override
        public void encode(ByteBuf p_422062_, GameProfile p_428503_) {
            UUIDUtil.STREAM_CODEC.encode(p_422062_, p_428503_.getId());
            Utf8String.write(p_422062_, p_428503_.getName(), 16);
            GAME_PROFILE_PROPERTIES.encode(p_422062_, p_428503_.getProperties());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (GameProfile)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> RGB_COLOR = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf p_422595_) {
            return ARGB.color(p_422595_.readByte() & 0xFF, p_422595_.readByte() & 0xFF, p_422595_.readByte() & 0xFF);
        }

        @Override
        public void encode(ByteBuf p_422247_, Integer p_428314_) {
            p_422247_.writeByte(ARGB.red(p_428314_));
            p_422247_.writeByte(ARGB.green(p_428314_));
            p_422247_.writeByte(ARGB.blue(p_428314_));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int p_324182_) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            public byte[] decode(ByteBuf p_320167_) {
                return FriendlyByteBuf.readByteArray(p_320167_, p_324182_);
            }

            @Override
            public void encode(ByteBuf p_320240_, byte[] p_341316_) {
                if (p_341316_.length > p_324182_) {
                    throw new EncoderException("ByteArray with size " + p_341316_.length + " is bigger than allowed " + p_324182_);
                }
                FriendlyByteBuf.writeByteArray(p_320240_, p_341316_);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (byte[])object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int p_320693_) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            public String decode(ByteBuf p_376272_) {
                return Utf8String.read(p_376272_, p_320693_);
            }

            @Override
            public void encode(ByteBuf p_376553_, String p_404954_) {
                Utf8String.write(p_376553_, p_404954_, p_320693_);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (String)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Optional<Tag>> optionalTagCodec(final Supplier<NbtAccounter> p_428461_) {
        return new StreamCodec<ByteBuf, Optional<Tag>>(){

            @Override
            public Optional<Tag> decode(ByteBuf p_404669_) {
                return Optional.ofNullable(FriendlyByteBuf.readNbt(p_404669_, (NbtAccounter)p_428461_.get()));
            }

            @Override
            public void encode(ByteBuf p_405814_, Optional<Tag> p_428357_) {
                FriendlyByteBuf.writeNbt(p_405814_, p_428357_.orElse(null));
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Tag> tagCodec(final Supplier<NbtAccounter> p_320506_) {
        return new StreamCodec<ByteBuf, Tag>(){

            @Override
            public Tag decode(ByteBuf p_421862_) {
                Tag $$1 = FriendlyByteBuf.readNbt(p_421862_, (NbtAccounter)p_320506_.get());
                if ($$1 == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return $$1;
            }

            @Override
            public void encode(ByteBuf p_422136_, Tag p_428274_) {
                if (p_428274_ == EndTag.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                FriendlyByteBuf.writeNbt(p_422136_, p_428274_);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (Tag)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> p_331128_) {
        return ByteBufCodecs.tagCodec(p_331128_).map(p_339405_ -> {
            if (p_339405_ instanceof CompoundTag) {
                CompoundTag $$1 = (CompoundTag)p_339405_;
                return $$1;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(p_339405_));
        }, p_330975_ -> p_330975_);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> p_331105_) {
        return ByteBufCodecs.fromCodec(p_331105_, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> p_320615_) {
        return ByteBufCodecs.fromCodec(p_320615_, () -> NbtAccounter.create(0x200000L));
    }

    public static <T, B extends ByteBuf, V> StreamCodec.CodecOperation<B, T, V> fromCodec(final DynamicOps<T> p_422160_, final Codec<V> p_421684_) {
        return p_428110_ -> new StreamCodec<B, V>(){

            @Override
            public V decode(B p_428561_) {
                Object $$1 = p_428110_.decode(p_428561_);
                return p_421684_.parse(p_422160_, $$1).getOrThrow(p_421833_ -> new DecoderException("Failed to decode: " + p_421833_ + " " + String.valueOf($$1)));
            }

            @Override
            public void encode(B p_428515_, V p_422051_) {
                Object $$2 = p_421684_.encodeStart(p_422160_, p_422051_).getOrThrow(p_421600_ -> new EncoderException("Failed to encode: " + p_421600_ + " " + String.valueOf(p_422051_)));
                p_428110_.encode(p_428515_, $$2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> p_330943_, Supplier<NbtAccounter> p_330382_) {
        return ByteBufCodecs.tagCodec(p_330382_).apply(ByteBufCodecs.fromCodec(NbtOps.INSTANCE, p_330943_));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> p_331713_) {
        return ByteBufCodecs.fromCodecWithRegistries(p_331713_, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> p_323797_) {
        return ByteBufCodecs.fromCodecWithRegistries(p_323797_, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> p_331571_, Supplier<NbtAccounter> p_331922_) {
        final StreamCodec<ByteBuf, Tag> $$2 = ByteBufCodecs.tagCodec(p_331922_);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            public T decode(RegistryFriendlyByteBuf p_428534_) {
                Tag $$1 = (Tag)$$2.decode(p_428534_);
                RegistryOps<Tag> $$22 = p_428534_.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                return p_331571_.parse($$22, (Object)$$1).getOrThrow(p_428554_ -> new DecoderException("Failed to decode: " + p_428554_ + " " + String.valueOf($$1)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_428528_, T p_428469_) {
                RegistryOps<Tag> $$22 = p_428528_.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Tag $$3 = (Tag)p_331571_.encodeStart($$22, p_428469_).getOrThrow(p_428492_ -> new EncoderException("Failed to encode: " + p_428492_ + " " + String.valueOf(p_428469_)));
                $$2.encode(p_428528_, $$3);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> p_320522_) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B p_363037_) {
                if (p_363037_.readBoolean()) {
                    return Optional.of(p_320522_.decode(p_363037_));
                }
                return Optional.empty();
            }

            @Override
            public void encode(B p_364013_, Optional<V> p_428441_) {
                if (p_428441_.isPresent()) {
                    p_364013_.writeBoolean(true);
                    p_320522_.encode(p_364013_, p_428441_.get());
                } else {
                    p_364013_.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static int readCount(ByteBuf p_331813_, int p_331668_) {
        int $$2 = VarInt.read(p_331813_);
        if ($$2 > p_331668_) {
            throw new DecoderException($$2 + " elements exceeded max size of: " + p_331668_);
        }
        return $$2;
    }

    public static void writeCount(ByteBuf p_330907_, int p_330535_, int p_331447_) {
        if (p_330535_ > p_331447_) {
            throw new EncoderException(p_330535_ + " elements exceeded max size of: " + p_331447_);
        }
        VarInt.write(p_330907_, p_330535_);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> p_320579_, StreamCodec<? super B, V> p_319970_) {
        return ByteBufCodecs.collection(p_320579_, p_319970_, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> p_332198_, final StreamCodec<? super B, V> p_332183_, final int p_332173_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_376474_) {
                int $$1 = ByteBufCodecs.readCount(p_376474_, p_332173_);
                Collection $$2 = (Collection)p_332198_.apply(Math.min($$1, 65536));
                for (int $$3 = 0; $$3 < $$1; ++$$3) {
                    $$2.add(p_332183_.decode(p_376474_));
                }
                return $$2;
            }

            @Override
            public void encode(B p_376188_, C p_428244_) {
                ByteBufCodecs.writeCount(p_376188_, p_428244_.size(), p_332173_);
                for (Object $$2 : p_428244_) {
                    p_332183_.encode(p_376188_, $$2);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (C)((Collection)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> p_319808_) {
        return p_319785_ -> ByteBufCodecs.collection(p_319808_, p_319785_);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return p_320272_ -> ByteBufCodecs.collection(ArrayList::new, p_320272_);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int p_330434_) {
        return p_329871_ -> ByteBufCodecs.collection(ArrayList::new, p_329871_, p_330434_);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> p_320265_, StreamCodec<? super B, K> p_320113_, StreamCodec<? super B, V> p_320275_) {
        return ByteBufCodecs.map(p_320265_, p_320113_, p_320275_, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> p_331325_, final StreamCodec<? super B, K> p_331975_, final StreamCodec<? super B, V> p_331254_, final int p_330938_) {
        return new StreamCodec<B, M>(){

            @Override
            public void encode(B p_405748_, M p_428450_) {
                ByteBufCodecs.writeCount(p_405748_, p_428450_.size(), p_330938_);
                p_428450_.forEach((p_428117_, p_428118_) -> {
                    p_331975_.encode(p_405748_, p_428117_);
                    p_331254_.encode(p_405748_, p_428118_);
                });
            }

            @Override
            public M decode(B p_405291_) {
                int $$1 = ByteBufCodecs.readCount(p_405291_, p_330938_);
                Map $$2 = (Map)p_331325_.apply(Math.min($$1, 65536));
                for (int $$3 = 0; $$3 < $$1; ++$$3) {
                    Object $$4 = p_331975_.decode(p_405291_);
                    Object $$5 = p_331254_.decode(p_405291_);
                    $$2.put($$4, $$5);
                }
                return $$2;
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (M)((Map)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> p_331983_, final StreamCodec<? super B, R> p_332156_) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B p_412599_) {
                if (p_412599_.readBoolean()) {
                    return Either.left(p_331983_.decode(p_412599_));
                }
                return Either.right(p_332156_.decode(p_412599_));
            }

            @Override
            public void encode(B p_412292_, Either<L, R> p_428253_) {
                p_428253_.ifLeft(p_428205_ -> {
                    p_412292_.writeBoolean(true);
                    p_331983_.encode(p_412292_, p_428205_);
                }).ifRight(p_428354_ -> {
                    p_412292_.writeBoolean(false);
                    p_332156_.encode(p_412292_, p_428354_);
                });
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Either)((Either)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, V> lengthPrefixed(final int p_412184_, final BiFunction<B, ByteBuf, B> p_412396_) {
        return p_428113_ -> new StreamCodec<B, V>(){

            @Override
            public V decode(B p_422567_) {
                int $$1 = VarInt.read(p_422567_);
                if ($$1 > p_412184_) {
                    throw new DecoderException("Buffer size " + $$1 + " is larger than allowed limit of " + p_412184_);
                }
                int $$2 = p_422567_.readerIndex();
                ByteBuf $$3 = (ByteBuf)p_412396_.apply(p_422567_, p_422567_.slice($$2, $$1));
                p_422567_.readerIndex($$2 + $$1);
                return p_428113_.decode($$3);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void encode(B p_422636_, V p_412065_) {
                ByteBuf $$2 = (ByteBuf)p_412396_.apply(p_422636_, p_422636_.alloc().buffer());
                try {
                    p_428113_.encode($$2, p_412065_);
                    int $$3 = $$2.readableBytes();
                    if ($$3 > p_412184_) {
                        throw new EncoderException("Buffer size " + $$3 + " is  larger than allowed limit of " + p_412184_);
                    }
                    VarInt.write(p_422636_, $$3);
                    p_422636_.writeBytes($$2);
                }
                finally {
                    $$2.release();
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <V> StreamCodec.CodecOperation<ByteBuf, V, V> lengthPrefixed(int p_412757_) {
        return ByteBufCodecs.lengthPrefixed(p_412757_, (p_428322_, p_428403_) -> p_428403_);
    }

    public static <V> StreamCodec.CodecOperation<RegistryFriendlyByteBuf, V, V> registryFriendlyLengthPrefixed(int p_428297_) {
        return ByteBufCodecs.lengthPrefixed(p_428297_, (p_412025_, p_412026_) -> new RegistryFriendlyByteBuf((ByteBuf)p_412026_, p_412025_.registryAccess()));
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> p_320877_, final ToIntFunction<T> p_319985_) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T decode(ByteBuf p_428190_) {
                int $$1 = VarInt.read(p_428190_);
                return p_320877_.apply($$1);
            }

            @Override
            public void encode(ByteBuf p_428271_, T p_421951_) {
                int $$2 = p_319985_.applyAsInt(p_421951_);
                VarInt.write(p_428271_, $$2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(IdMap<T> p_319822_) {
        return ByteBufCodecs.idMapper(p_319822_::byIdOrThrow, p_319822_::getIdOrThrow);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends Registry<T>> p_319942_, final Function<Registry<T>, IdMap<R>> p_320353_) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private IdMap<R> getRegistryOrThrow(RegistryFriendlyByteBuf p_421864_) {
                return (IdMap)p_320353_.apply(p_421864_.registryAccess().lookupOrThrow(p_319942_));
            }

            @Override
            public R decode(RegistryFriendlyByteBuf p_412249_) {
                int $$1 = VarInt.read(p_412249_);
                return this.getRegistryOrThrow(p_412249_).byIdOrThrow($$1);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_412573_, R p_428521_) {
                int $$2 = this.getRegistryOrThrow(p_412573_).getIdOrThrow(p_428521_);
                VarInt.write(p_412573_, $$2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends Registry<T>> p_320404_) {
        return ByteBufCodecs.registry(p_320404_, p_428107_ -> p_428107_);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends Registry<T>> p_320387_) {
        return ByteBufCodecs.registry(p_320387_, Registry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends Registry<T>> p_320391_, final StreamCodec<? super RegistryFriendlyByteBuf, T> p_320595_) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private IdMap<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf p_428365_) {
                return p_428365_.registryAccess().lookupOrThrow(p_320391_).asHolderIdMap();
            }

            @Override
            public Holder<T> decode(RegistryFriendlyByteBuf p_421902_) {
                int $$1 = VarInt.read(p_421902_);
                if ($$1 == 0) {
                    return Holder.direct(p_320595_.decode(p_421902_));
                }
                return this.getRegistryOrThrow(p_421902_).byIdOrThrow($$1 - 1);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_422033_, Holder<T> p_428456_) {
                switch (p_428456_.kind()) {
                    case REFERENCE: {
                        int $$2 = this.getRegistryOrThrow(p_422033_).getIdOrThrow(p_428456_);
                        VarInt.write(p_422033_, $$2 + 1);
                        break;
                    }
                    case DIRECT: {
                        VarInt.write(p_422033_, 0);
                        p_320595_.encode(p_422033_, p_428456_.value());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (Holder)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends Registry<T>> p_332137_) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry(p_332137_);
            }

            @Override
            public HolderSet<T> decode(RegistryFriendlyByteBuf p_428283_) {
                int $$1 = VarInt.read(p_428283_) - 1;
                if ($$1 == -1) {
                    HolderLookup.RegistryLookup $$2 = p_428283_.registryAccess().lookupOrThrow(p_332137_);
                    return (HolderSet)$$2.get(TagKey.create(p_332137_, (ResourceLocation)ResourceLocation.STREAM_CODEC.decode(p_428283_))).orElseThrow();
                }
                ArrayList<Holder> $$3 = new ArrayList<Holder>(Math.min($$1, 65536));
                for (int $$4 = 0; $$4 < $$1; ++$$4) {
                    $$3.add((Holder)this.holderCodec.decode(p_428283_));
                }
                return HolderSet.direct($$3);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_428187_, HolderSet<T> p_428305_) {
                Optional $$2 = p_428305_.unwrapKey();
                if ($$2.isPresent()) {
                    VarInt.write(p_428187_, 0);
                    ResourceLocation.STREAM_CODEC.encode(p_428187_, $$2.get().location());
                } else {
                    VarInt.write(p_428187_, p_428305_.size() + 1);
                    for (Holder holder : p_428305_) {
                        this.holderCodec.encode(p_428187_, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (HolderSet)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static StreamCodec<ByteBuf, JsonElement> lenientJson(final int p_422673_) {
        return new StreamCodec<ByteBuf, JsonElement>(){
            private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

            @Override
            public JsonElement decode(ByteBuf p_428344_) {
                String $$1 = Utf8String.read(p_428344_, p_422673_);
                try {
                    return LenientJsonParser.parse($$1);
                }
                catch (JsonSyntaxException $$2) {
                    throw new DecoderException("Failed to parse JSON", (Throwable)$$2);
                }
            }

            @Override
            public void encode(ByteBuf p_428191_, JsonElement p_428484_) {
                String $$2 = GSON.toJson(p_428484_);
                Utf8String.write(p_428191_, $$2, p_422673_);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (JsonElement)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }
}

