/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record MessageSignature(byte[] bytes) {
    public static final Codec<MessageSignature> CODEC = ExtraCodecs.BASE64_STRING.xmap(MessageSignature::new, MessageSignature::bytes);
    public static final int BYTES = 256;

    public MessageSignature {
        Preconditions.checkState((bytes.length == 256 ? 1 : 0) != 0, (Object)"Invalid message signature size");
    }

    public static MessageSignature read(FriendlyByteBuf p_249837_) {
        byte[] $$1 = new byte[256];
        p_249837_.readBytes($$1);
        return new MessageSignature($$1);
    }

    public static void write(FriendlyByteBuf p_250642_, MessageSignature p_249714_) {
        p_250642_.writeBytes(p_249714_.bytes);
    }

    public boolean verify(SignatureValidator p_250998_, SignatureUpdater p_249843_) {
        return p_250998_.validate(p_249843_, this.bytes);
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.bytes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object p_237166_) {
        if (this == p_237166_) return true;
        if (!(p_237166_ instanceof MessageSignature)) return false;
        MessageSignature $$1 = (MessageSignature)p_237166_;
        if (!Arrays.equals(this.bytes, $$1.bytes)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    public static String describe(@Nullable MessageSignature p_412489_) {
        if (p_412489_ == null) {
            return "<no signature>";
        }
        return p_412489_.toString();
    }

    public Packed pack(MessageSignatureCache p_253845_) {
        int $$1 = p_253845_.pack(this);
        return $$1 != -1 ? new Packed($$1) : new Packed(this);
    }

    public int checksum() {
        return Arrays.hashCode(this.bytes);
    }

    public record Packed(int id, @Nullable MessageSignature fullSignature) {
        public static final int FULL_SIGNATURE = -1;

        public Packed(MessageSignature p_249705_) {
            this(-1, p_249705_);
        }

        public Packed(int p_250015_) {
            this(p_250015_, null);
        }

        public static Packed read(FriendlyByteBuf p_250810_) {
            int $$1 = p_250810_.readVarInt() - 1;
            if ($$1 == -1) {
                return new Packed(MessageSignature.read(p_250810_));
            }
            return new Packed($$1);
        }

        public static void write(FriendlyByteBuf p_251691_, Packed p_252193_) {
            p_251691_.writeVarInt(p_252193_.id() + 1);
            if (p_252193_.fullSignature() != null) {
                MessageSignature.write(p_251691_, p_252193_.fullSignature());
            }
        }

        public Optional<MessageSignature> unpack(MessageSignatureCache p_254423_) {
            if (this.fullSignature != null) {
                return Optional.of(this.fullSignature);
            }
            return Optional.ofNullable(p_254423_.unpack(this.id));
        }
    }
}

