/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public record StringTag(String value) implements PrimitiveTag
{
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final TagType<StringTag> TYPE = new TagType.VariableSize<StringTag>(){

        @Override
        public StringTag load(DataInput p_129320_, NbtAccounter p_129322_) throws IOException {
            return StringTag.valueOf(1.readAccounted(p_129320_, p_129322_));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197570_, StreamTagVisitor p_197571_, NbtAccounter p_302336_) throws IOException {
            return p_197571_.visit(1.readAccounted(p_197570_, p_302336_));
        }

        private static String readAccounted(DataInput p_302398_, NbtAccounter p_302365_) throws IOException {
            p_302365_.accountBytes(36L);
            String $$2 = p_302398_.readUTF();
            p_302365_.accountBytes(2L, $$2.length());
            return $$2;
        }

        @Override
        public void skip(DataInput p_197568_, NbtAccounter p_302356_) throws IOException {
            StringTag.skipString(p_197568_);
        }

        @Override
        public String getName() {
            return "STRING";
        }

        @Override
        public String getPrettyName() {
            return "TAG_String";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private static final StringTag EMPTY = new StringTag("");
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char NOT_SET = '\u0000';

    public static void skipString(DataInput p_197564_) throws IOException {
        p_197564_.skipBytes(p_197564_.readUnsignedShort());
    }

    public static StringTag valueOf(String p_129298_) {
        if (p_129298_.isEmpty()) {
            return EMPTY;
        }
        return new StringTag(p_129298_);
    }

    @Override
    public void write(DataOutput p_129296_) throws IOException {
        p_129296_.writeUTF(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 36 + 2 * this.value.length();
    }

    @Override
    public byte getId() {
        return 8;
    }

    public TagType<StringTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor $$0 = new StringTagVisitor();
        $$0.visitString(this);
        return $$0.build();
    }

    @Override
    public StringTag copy() {
        return this;
    }

    @Override
    public Optional<String> asString() {
        return Optional.of(this.value);
    }

    @Override
    public void accept(TagVisitor p_178154_) {
        p_178154_.visitString(this);
    }

    public static String quoteAndEscape(String p_129304_) {
        StringBuilder $$1 = new StringBuilder();
        StringTag.quoteAndEscape(p_129304_, $$1);
        return $$1.toString();
    }

    public static void quoteAndEscape(String p_410719_, StringBuilder p_409607_) {
        int $$2 = p_409607_.length();
        p_409607_.append(' ');
        int $$3 = 0;
        for (int $$4 = 0; $$4 < p_410719_.length(); ++$$4) {
            int $$5 = p_410719_.charAt($$4);
            if ($$5 == 92) {
                p_409607_.append("\\\\");
                continue;
            }
            if ($$5 == 34 || $$5 == 39) {
                if ($$3 == 0) {
                    int n = $$3 = $$5 == 34 ? 39 : 34;
                }
                if ($$3 == $$5) {
                    p_409607_.append('\\');
                }
                p_409607_.append((char)$$5);
                continue;
            }
            String $$6 = SnbtGrammar.escapeControlCharacters((char)$$5);
            if ($$6 != null) {
                p_409607_.append('\\');
                p_409607_.append($$6);
                continue;
            }
            p_409607_.append((char)$$5);
        }
        if ($$3 == 0) {
            $$3 = 34;
        }
        p_409607_.setCharAt($$2, (char)$$3);
        p_409607_.append((char)$$3);
    }

    public static String escapeWithoutQuotes(String p_428687_) {
        StringBuilder $$1 = new StringBuilder();
        StringTag.escapeWithoutQuotes(p_428687_, $$1);
        return $$1.toString();
    }

    public static void escapeWithoutQuotes(String p_428715_, StringBuilder p_428716_) {
        block3: for (int $$2 = 0; $$2 < p_428715_.length(); ++$$2) {
            char $$3 = p_428715_.charAt($$2);
            switch ($$3) {
                case '\"': 
                case '\'': 
                case '\\': {
                    p_428716_.append('\\');
                    p_428716_.append($$3);
                    continue block3;
                }
                default: {
                    String $$4 = SnbtGrammar.escapeControlCharacters($$3);
                    if ($$4 != null) {
                        p_428716_.append('\\');
                        p_428716_.append($$4);
                        continue block3;
                    }
                    p_428716_.append($$3);
                }
            }
        }
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197566_) {
        return p_197566_.visit(this.value);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

