/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class IntArrayTag
implements CollectionTag {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final TagType<IntArrayTag> TYPE = new TagType.VariableSize<IntArrayTag>(){

        @Override
        public IntArrayTag load(DataInput p_128662_, NbtAccounter p_128664_) throws IOException {
            return new IntArrayTag(1.readAccounted(p_128662_, p_128664_));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197478_, StreamTagVisitor p_197479_, NbtAccounter p_302360_) throws IOException {
            return p_197479_.visit(1.readAccounted(p_197478_, p_302360_));
        }

        private static int[] readAccounted(DataInput p_302381_, NbtAccounter p_302330_) throws IOException {
            p_302330_.accountBytes(24L);
            int $$2 = p_302381_.readInt();
            p_302330_.accountBytes(4L, $$2);
            int[] $$3 = new int[$$2];
            for (int $$4 = 0; $$4 < $$2; ++$$4) {
                $$3[$$4] = p_302381_.readInt();
            }
            return $$3;
        }

        @Override
        public void skip(DataInput p_197476_, NbtAccounter p_302380_) throws IOException {
            p_197476_.skipBytes(p_197476_.readInt() * 4);
        }

        @Override
        public String getName() {
            return "INT[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Int_Array";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private int[] data;

    public IntArrayTag(int[] p_128605_) {
        this.data = p_128605_;
    }

    @Override
    public void write(DataOutput p_128616_) throws IOException {
        p_128616_.writeInt(this.data.length);
        for (int $$1 : this.data) {
            p_128616_.writeInt($$1);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 4 * this.data.length;
    }

    @Override
    public byte getId() {
        return 11;
    }

    public TagType<IntArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor $$0 = new StringTagVisitor();
        $$0.visitIntArray(this);
        return $$0.build();
    }

    @Override
    public IntArrayTag copy() {
        int[] $$0 = new int[this.data.length];
        System.arraycopy(this.data, 0, $$0, 0, this.data.length);
        return new IntArrayTag($$0);
    }

    public boolean equals(Object p_128647_) {
        if (this == p_128647_) {
            return true;
        }
        return p_128647_ instanceof IntArrayTag && Arrays.equals(this.data, ((IntArrayTag)p_128647_).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public int[] getAsIntArray() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor p_177869_) {
        p_177869_.visitIntArray(this);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public IntTag get(int p_128608_) {
        return IntTag.valueOf(this.data[p_128608_]);
    }

    @Override
    public boolean setTag(int p_128613_, Tag p_128614_) {
        if (p_128614_ instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)p_128614_;
            this.data[p_128613_] = $$2.intValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int p_128632_, Tag p_128633_) {
        if (p_128633_ instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)p_128633_;
            this.data = ArrayUtils.add((int[])this.data, (int)p_128632_, (int)$$2.intValue());
            return true;
        }
        return false;
    }

    @Override
    public IntTag remove(int p_128627_) {
        int $$1 = this.data[p_128627_];
        this.data = ArrayUtils.remove((int[])this.data, (int)p_128627_);
        return IntTag.valueOf($$1);
    }

    @Override
    public void clear() {
        this.data = new int[0];
    }

    @Override
    public Optional<int[]> asIntArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197474_) {
        return p_197474_.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag get(int n) {
        return this.get(n);
    }

    @Override
    public /* synthetic */ Tag remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

