/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.TestBlockMode;

public class BlockBasedTestInstance
extends GameTestInstance {
    public static final MapCodec<BlockBasedTestInstance> CODEC = RecordCodecBuilder.mapCodec(p_397683_ -> p_397683_.group((App)TestData.CODEC.forGetter(GameTestInstance::info)).apply((Applicative)p_397683_, BlockBasedTestInstance::new));

    public BlockBasedTestInstance(TestData<Holder<TestEnvironmentDefinition>> p_397064_) {
        super(p_397064_);
    }

    @Override
    public void run(GameTestHelper p_397754_) {
        BlockPos $$1 = this.findStartBlock(p_397754_);
        TestBlockEntity $$2 = p_397754_.getBlockEntity($$1, TestBlockEntity.class);
        $$2.trigger();
        p_397754_.onEachTick(() -> {
            boolean $$2;
            List<BlockPos> $$1 = this.findTestBlocks(p_397754_, TestBlockMode.ACCEPT);
            if ($$1.isEmpty()) {
                p_397754_.fail(Component.translatable("test_block.error.missing", TestBlockMode.ACCEPT.getDisplayName()));
            }
            if ($$2 = $$1.stream().map(p_400878_ -> p_397754_.getBlockEntity((BlockPos)p_400878_, TestBlockEntity.class)).anyMatch(TestBlockEntity::hasTriggered)) {
                p_397754_.succeed();
            } else {
                this.forAllTriggeredTestBlocks(p_397754_, TestBlockMode.FAIL, p_397155_ -> p_397754_.fail(Component.literal(p_397155_.getMessage())));
                this.forAllTriggeredTestBlocks(p_397754_, TestBlockMode.LOG, TestBlockEntity::trigger);
            }
        });
    }

    private void forAllTriggeredTestBlocks(GameTestHelper p_397789_, TestBlockMode p_397661_, Consumer<TestBlockEntity> p_397861_) {
        List<BlockPos> $$3 = this.findTestBlocks(p_397789_, p_397661_);
        for (BlockPos $$4 : $$3) {
            TestBlockEntity $$5 = p_397789_.getBlockEntity($$4, TestBlockEntity.class);
            if (!$$5.hasTriggered()) continue;
            p_397861_.accept($$5);
            $$5.reset();
        }
    }

    private BlockPos findStartBlock(GameTestHelper p_397254_) {
        List<BlockPos> $$1 = this.findTestBlocks(p_397254_, TestBlockMode.START);
        if ($$1.isEmpty()) {
            p_397254_.fail(Component.translatable("test_block.error.missing", TestBlockMode.START.getDisplayName()));
        }
        if ($$1.size() != 1) {
            p_397254_.fail(Component.translatable("test_block.error.too_many", TestBlockMode.START.getDisplayName()));
        }
        return $$1.getFirst();
    }

    private List<BlockPos> findTestBlocks(GameTestHelper p_397394_, TestBlockMode p_397286_) {
        ArrayList<BlockPos> $$2 = new ArrayList<BlockPos>();
        p_397394_.forEveryBlockInStructure(p_397203_ -> {
            BlockState $$4 = p_397394_.getBlockState((BlockPos)p_397203_);
            if ($$4.is(Blocks.TEST_BLOCK) && $$4.getValue(TestBlock.MODE) == p_397286_) {
                $$2.add(p_397203_.immutable());
            }
        });
        return $$2;
    }

    public MapCodec<BlockBasedTestInstance> codec() {
        return CODEC;
    }

    @Override
    protected MutableComponent typeDescription() {
        return Component.translatable("test_instance.type.block_based");
    }
}

