/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceKey<LootTable>> p_254481_, List<SubProviderEntry> p_253798_, CompletableFuture<HolderLookup.Provider> p_323798_) {
        this.pathProvider = p_254123_.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
        this.subProviders = p_253798_;
        this.requiredTables = p_254481_;
        this.registries = p_323798_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254060_) {
        return this.registries.thenCompose(p_323117_ -> this.run(p_254060_, (HolderLookup.Provider)p_323117_));
    }

    private CompletableFuture<?> run(CachedOutput p_324447_, HolderLookup.Provider p_323978_) {
        MappedRegistry<LootTable> $$2 = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap $$3 = new Object2ObjectOpenHashMap();
        this.subProviders.forEach(arg_0 -> LootTableProvider.lambda$run$2(p_323978_, (Map)$$3, $$2, arg_0));
        $$2.freeze();
        ProblemReporter.Collector $$4 = new ProblemReporter.Collector();
        RegistryAccess.Frozen $$5 = new RegistryAccess.ImmutableRegistryAccess(List.of($$2)).freeze();
        ValidationContext $$6 = new ValidationContext($$4, LootContextParamSets.ALL_PARAMS, $$5);
        Sets.SetView $$7 = Sets.difference(this.requiredTables, $$2.registryKeySet());
        for (ResourceKey $$8 : $$7) {
            $$4.report(new MissingTableProblem($$8));
        }
        $$2.listElements().forEach(p_421302_ -> ((LootTable)p_421302_.value()).validate($$6.setContextKeySet(((LootTable)p_421302_.value()).getParamSet()).enterElement(new ProblemReporter.RootElementPathElement(p_421302_.key()), p_421302_.key())));
        if (!$$4.isEmpty()) {
            $$4.forEach((p_421299_, p_421300_) -> LOGGER.warn("Found validation problem in {}: {}", p_421299_, (Object)p_421300_.description()));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])$$2.entrySet().stream().map(p_335193_ -> {
            ResourceKey $$3 = (ResourceKey)p_335193_.getKey();
            LootTable $$4 = (LootTable)p_335193_.getValue();
            Path $$5 = this.pathProvider.json($$3.location());
            return DataProvider.saveStable(p_324447_, p_323978_, LootTable.DIRECT_CODEC, $$4, $$5);
        }).toArray(CompletableFuture[]::new));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> p_336172_) {
        return p_336172_.location();
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider p_344194_, Map p_344195_, WritableRegistry p_344196_, SubProviderEntry p_344197_) {
        p_344197_.provider().apply(p_344194_).generate((p_380827_, p_380828_) -> {
            ResourceLocation $$5 = LootTableProvider.sequenceIdForLootTable(p_380827_);
            ResourceLocation $$6 = p_344195_.put(RandomSequence.seedForKey($$5), $$5);
            if ($$6 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf($$6) + " and " + String.valueOf(p_380827_.location()));
            }
            p_380828_.setRandomSequence($$5);
            LootTable $$7 = p_380828_.setParamSet(p_380825_.paramSet).build();
            p_344196_.register(p_380827_, $$7, RegistrationInfo.BUILT_IN);
        });
    }

    public record MissingTableProblem(ResourceKey<LootTable> id) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Missing built-in table: " + String.valueOf(this.id.location());
        }
    }

    public record SubProviderEntry(Function<HolderLookup.Provider, LootTableSubProvider> provider, ContextKeySet paramSet) {
    }
}

