/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public abstract class EntityLootSubProvider
implements LootTableSubProvider {
    protected final HolderLookup.Provider registries;
    private final FeatureFlagSet allowed;
    private final FeatureFlagSet required;
    private final Map<EntityType<?>, Map<ResourceKey<LootTable>, LootTable.Builder>> map = Maps.newHashMap();

    protected final AnyOfCondition.Builder shouldSmeltLoot() {
        HolderGetter $$0 = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return AnyOfCondition.anyOf(LootItemEntityPropertyCondition.hasProperties(LootContext.EntityTarget.THIS, EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(true))), LootItemEntityPropertyCondition.hasProperties(LootContext.EntityTarget.DIRECT_ATTACKER, EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate($$0.getOrThrow(EnchantmentTags.SMELTS_LOOT), MinMaxBounds.Ints.ANY)))).build())))));
    }

    protected EntityLootSubProvider(FeatureFlagSet p_266989_, HolderLookup.Provider p_345284_) {
        this(p_266989_, p_266989_, p_345284_);
    }

    protected EntityLootSubProvider(FeatureFlagSet p_251971_, FeatureFlagSet p_345117_, HolderLookup.Provider p_344819_) {
        this.allowed = p_251971_;
        this.required = p_345117_;
        this.registries = p_344819_;
    }

    public static LootPool.Builder createSheepDispatchPool(Map<DyeColor, ResourceKey<LootTable>> p_368504_) {
        AlternativesEntry.Builder $$1 = AlternativesEntry.alternatives(new LootPoolEntryContainer.Builder[0]);
        for (Map.Entry<DyeColor, ResourceKey<LootTable>> $$2 : p_368504_.entrySet()) {
            $$1 = $$1.otherwise((LootPoolEntryContainer.Builder<?>)NestedLootTable.lootTableReference($$2.getValue()).when(LootItemEntityPropertyCondition.hasProperties(LootContext.EntityTarget.THIS, EntityPredicate.Builder.entity().components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect(DataComponents.SHEEP_COLOR, $$2.getKey())).build()).subPredicate(SheepPredicate.hasWool()))));
        }
        return LootPool.lootPool().add($$1);
    }

    public abstract void generate();

    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> p_251751_) {
        this.generate();
        HashSet $$1 = new HashSet();
        BuiltInRegistries.ENTITY_TYPE.listElements().forEach(p_367828_ -> {
            EntityType $$3 = (EntityType)p_367828_.value();
            if (!$$3.isEnabled(this.allowed)) {
                return;
            }
            Optional<ResourceKey<LootTable>> $$4 = $$3.getDefaultLootTable();
            if ($$4.isPresent()) {
                Map<ResourceKey<LootTable>, LootTable.Builder> $$5 = this.map.remove($$3);
                if ($$3.isEnabled(this.required) && ($$5 == null || !$$5.containsKey($$4.get()))) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", $$4.get(), p_367828_.key().location()));
                }
                if ($$5 != null) {
                    $$5.forEach((p_335546_, p_250972_) -> {
                        if (!$$1.add(p_335546_)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", p_335546_, p_367828_.key().location()));
                        }
                        p_251751_.accept((ResourceKey<LootTable>)p_335546_, (LootTable.Builder)p_250972_);
                    });
                }
            } else {
                Map<ResourceKey<LootTable>, LootTable.Builder> $$6 = this.map.remove($$3);
                if ($$6 != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", $$6.keySet().stream().map(p_335190_ -> p_335190_.location().toString()).collect(Collectors.joining(",")), p_367828_.key().location()));
                }
            }
        });
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + String.valueOf(this.map.keySet()));
        }
    }

    protected LootItemCondition.Builder killedByFrog(HolderGetter<EntityType<?>> p_361765_) {
        return DamageSourceCondition.hasDamageSource(DamageSourcePredicate.Builder.damageType().source(EntityPredicate.Builder.entity().of(p_361765_, EntityType.FROG)));
    }

    protected LootItemCondition.Builder killedByFrogVariant(HolderGetter<EntityType<?>> p_362844_, HolderGetter<FrogVariant> p_399949_, ResourceKey<FrogVariant> p_335676_) {
        return DamageSourceCondition.hasDamageSource(DamageSourcePredicate.Builder.damageType().source(EntityPredicate.Builder.entity().of(p_362844_, EntityType.FROG).components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect(DataComponents.FROG_VARIANT, p_399949_.getOrThrow(p_335676_))).build())));
    }

    protected void add(EntityType<?> p_248740_, LootTable.Builder p_249440_) {
        this.add(p_248740_, p_248740_.getDefaultLootTable().orElseThrow(() -> new IllegalStateException("Entity " + String.valueOf(p_248740_) + " has no loot table")), p_249440_);
    }

    protected void add(EntityType<?> p_252130_, ResourceKey<LootTable> p_335943_, LootTable.Builder p_249357_) {
        this.map.computeIfAbsent(p_252130_, p_251466_ -> new HashMap()).put(p_335943_, p_249357_);
    }
}

