/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockListReport
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public BlockListReport(PackOutput p_251533_, CompletableFuture<HolderLookup.Provider> p_330926_) {
        this.output = p_251533_;
        this.registries = p_330926_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_236197_) {
        Path $$1 = this.output.getOutputFolder(PackOutput.Target.REPORTS).resolve("blocks.json");
        return this.registries.thenCompose(p_367817_ -> {
            JsonObject $$3 = new JsonObject();
            RegistryOps $$4 = p_367817_.createSerializationContext(JsonOps.INSTANCE);
            p_367817_.lookupOrThrow(Registries.BLOCK).listElements().forEach(p_330336_ -> {
                JsonObject $$3 = new JsonObject();
                StateDefinition<Block, BlockState> $$4 = ((Block)p_330336_.value()).getStateDefinition();
                if (!$$4.getProperties().isEmpty()) {
                    JsonObject $$5 = new JsonObject();
                    for (Property property : $$4.getProperties()) {
                        JsonArray $$7 = new JsonArray();
                        for (Comparable $$8 : property.getPossibleValues()) {
                            $$7.add(Util.getPropertyName(property, $$8));
                        }
                        $$5.add(property.getName(), (JsonElement)$$7);
                    }
                    $$3.add("properties", (JsonElement)$$5);
                }
                JsonArray $$9 = new JsonArray();
                for (BlockState blockState : $$4.getPossibleStates()) {
                    JsonObject $$11 = new JsonObject();
                    JsonObject $$12 = new JsonObject();
                    for (Property<?> $$13 : $$4.getProperties()) {
                        $$12.addProperty($$13.getName(), Util.getPropertyName($$13, blockState.getValue($$13)));
                    }
                    if ($$12.size() > 0) {
                        $$11.add("properties", (JsonElement)$$12);
                    }
                    $$11.addProperty("id", (Number)Block.getId(blockState));
                    if (blockState == ((Block)p_330336_.value()).defaultBlockState()) {
                        $$11.addProperty("default", Boolean.valueOf(true));
                    }
                    $$9.add((JsonElement)$$11);
                }
                $$3.add("states", (JsonElement)$$9);
                String $$14 = p_330336_.getRegisteredName();
                JsonElement jsonElement = (JsonElement)BlockTypes.CODEC.codec().encodeStart((DynamicOps)$$4, (Object)((Block)p_330336_.value())).getOrThrow(p_331670_ -> new AssertionError((Object)("Failed to serialize block " + $$14 + " (is type registered in BlockTypes?): " + p_331670_)));
                $$3.add("definition", jsonElement);
                $$3.add($$14, (JsonElement)$$3);
            });
            return DataProvider.saveStable(p_236197_, (JsonElement)$$3, $$1);
        });
    }

    @Override
    public final String getName() {
        return "Block List";
    }
}

