/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class ShearsDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    @Override
    protected ItemStack execute(BlockSource p_302443_, ItemStack p_123581_) {
        ServerLevel $$2 = p_302443_.level();
        if (!$$2.isClientSide()) {
            BlockPos $$3 = p_302443_.pos().relative(p_302443_.state().getValue(DispenserBlock.FACING));
            this.setSuccess(ShearsDispenseItemBehavior.tryShearBeehive($$2, $$3) || ShearsDispenseItemBehavior.tryShearEntity($$2, $$3, p_123581_));
            if (this.isSuccess()) {
                p_123581_.hurtAndBreak(1, $$2, null, p_348118_ -> {});
            }
        }
        return p_123581_;
    }

    private static boolean tryShearBeehive(ServerLevel p_123577_, BlockPos p_123578_) {
        int $$3;
        BlockState $$2 = p_123577_.getBlockState(p_123578_);
        if ($$2.is(BlockTags.BEEHIVES, p_202454_ -> p_202454_.hasProperty(BeehiveBlock.HONEY_LEVEL) && p_202454_.getBlock() instanceof BeehiveBlock) && ($$3 = $$2.getValue(BeehiveBlock.HONEY_LEVEL).intValue()) >= 5) {
            p_123577_.playSound(null, p_123578_, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb(p_123577_, p_123578_);
            ((BeehiveBlock)$$2.getBlock()).releaseBeesAndResetHoneyLevel(p_123577_, $$2, p_123578_, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            p_123577_.gameEvent(null, GameEvent.SHEAR, p_123578_);
            return true;
        }
        return false;
    }

    private static boolean tryShearEntity(ServerLevel p_418032_, BlockPos p_418277_, ItemStack p_418413_) {
        List<Entity> $$3 = p_418032_.getEntitiesOfClass(Entity.class, new AABB(p_418277_), EntitySelector.NO_SPECTATORS);
        for (Entity $$4 : $$3) {
            Shearable $$5;
            if ($$4.shearOffAllLeashConnections(null)) {
                return true;
            }
            if (!($$4 instanceof Shearable) || !($$5 = (Shearable)((Object)$$4)).readyForShearing()) continue;
            $$5.shear(p_418032_, SoundSource.BLOCKS, p_418413_);
            p_418032_.gameEvent(null, GameEvent.SHEAR, p_418277_);
            return true;
        }
        return false;
    }
}

