/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class MinecartDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final EntityType<? extends AbstractMinecart> entityType;

    public MinecartDispenseItemBehavior(EntityType<? extends AbstractMinecart> p_374102_) {
        this.entityType = p_374102_;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ItemStack execute(BlockSource p_374045_, ItemStack p_374580_) {
        void $$16;
        Direction $$2 = p_374045_.state().getValue(DispenserBlock.FACING);
        ServerLevel $$3 = p_374045_.level();
        Vec3 $$4 = p_374045_.center();
        double $$5 = $$4.x() + (double)$$2.getStepX() * 1.125;
        double $$6 = Math.floor($$4.y()) + (double)$$2.getStepY();
        double $$7 = $$4.z() + (double)$$2.getStepZ() * 1.125;
        BlockPos $$8 = p_374045_.pos().relative($$2);
        BlockState $$9 = $$3.getBlockState($$8);
        if ($$9.is(BlockTags.RAILS)) {
            if (MinecartDispenseItemBehavior.getRailShape($$9).isSlope()) {
                double $$10 = 0.6;
            } else {
                double $$11 = 0.1;
            }
        } else {
            if (!$$9.isAir()) return this.defaultDispenseItemBehavior.dispense(p_374045_, p_374580_);
            BlockState $$12 = $$3.getBlockState($$8.below());
            if (!$$12.is(BlockTags.RAILS)) return this.defaultDispenseItemBehavior.dispense(p_374045_, p_374580_);
            if ($$2 == Direction.DOWN || !MinecartDispenseItemBehavior.getRailShape($$12).isSlope()) {
                double $$13 = -0.9;
            } else {
                double $$14 = -0.4;
            }
        }
        Vec3 $$17 = new Vec3($$5, $$6 + $$16, $$7);
        AbstractMinecart $$18 = AbstractMinecart.createMinecart($$3, $$17.x, $$17.y, $$17.z, this.entityType, EntitySpawnReason.DISPENSER, p_374580_, null);
        if ($$18 == null) return p_374580_;
        $$3.addFreshEntity($$18);
        p_374580_.shrink(1);
        return p_374580_;
    }

    private static RailShape getRailShape(BlockState p_374571_) {
        RailShape railShape;
        Block block = p_374571_.getBlock();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock $$1 = (BaseRailBlock)block;
            railShape = p_374571_.getValue($$1.getShapeProperty());
        } else {
            railShape = RailShape.NORTH_SOUTH;
        }
        return railShape;
    }

    @Override
    protected void playSound(BlockSource p_374042_) {
        p_374042_.level().levelEvent(1000, p_374042_.pos(), 0);
    }
}

