/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.TraceCallbacks;

public interface CustomCommandExecutor<T> {
    public void run(T var1, ContextChain<T> var2, ChainModifiers var3, ExecutionControl<T> var4);

    public static abstract class WithErrorHandling<T extends ExecutionCommandSource<T>>
    implements CustomCommandExecutor<T> {
        @Override
        public final void run(T p_306339_, ContextChain<T> p_306289_, ChainModifiers p_309578_, ExecutionControl<T> p_306027_) {
            try {
                this.runGuarded(p_306339_, p_306289_, p_309578_, p_306027_);
            }
            catch (CommandSyntaxException $$4) {
                this.onError($$4, p_306339_, p_309578_, p_306027_.tracer());
                p_306339_.callback().onFailure();
            }
        }

        protected void onError(CommandSyntaxException p_306165_, T p_306155_, ChainModifiers p_309597_, @Nullable TraceCallbacks p_307254_) {
            p_306155_.handleError(p_306165_, p_309597_.isForked(), p_307254_);
        }

        protected abstract void runGuarded(T var1, ContextChain<T> var2, ChainModifiers var3, ExecutionControl<T> var4) throws CommandSyntaxException;
    }

    public static interface CommandAdapter<T>
    extends Command<T>,
    CustomCommandExecutor<T> {
        default public int run(CommandContext<T> p_306336_) throws CommandSyntaxException {
            throw new UnsupportedOperationException("This function should not run");
        }
    }
}

