/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.Listener;
import com.mojang.blaze3d.audio.ListenerTransform;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundEngineExecutor;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SoundEngine {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"SOUNDS");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PITCH_MIN = 0.5f;
    private static final float PITCH_MAX = 2.0f;
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 1.0f;
    private static final int MIN_SOURCE_LIFETIME = 20;
    private static final Set<ResourceLocation> ONLY_WARN_ONCE = Sets.newHashSet();
    private static final long DEFAULT_DEVICE_CHECK_INTERVAL_MS = 1000L;
    public static final String MISSING_SOUND = "FOR THE DEBUG!";
    public static final String OPEN_AL_SOFT_PREFIX = "OpenAL Soft on ";
    public static final int OPEN_AL_SOFT_PREFIX_LENGTH = "OpenAL Soft on ".length();
    private final MusicManager musicManager;
    private final SoundManager soundManager;
    private final Options options;
    private boolean loaded;
    private final Library library = new Library();
    private final Listener listener = this.library.getListener();
    private final SoundBufferLibrary soundBuffers;
    private final SoundEngineExecutor executor = new SoundEngineExecutor();
    private final ChannelAccess channelAccess = new ChannelAccess(this.library, this.executor);
    private int tickCount;
    private long lastDeviceCheckTime;
    private final AtomicReference<DeviceCheckState> devicePoolState = new AtomicReference<DeviceCheckState>(DeviceCheckState.NO_CHANGE);
    private final Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel = Maps.newHashMap();
    private final Multimap<SoundSource, SoundInstance> instanceBySource = HashMultimap.create();
    private final List<TickableSoundInstance> tickingSounds = Lists.newArrayList();
    private final Map<SoundInstance, Integer> queuedSounds = Maps.newHashMap();
    private final Map<SoundInstance, Integer> soundDeleteTime = Maps.newHashMap();
    private final List<SoundEventListener> listeners = Lists.newArrayList();
    private final List<TickableSoundInstance> queuedTickableSounds = Lists.newArrayList();
    private final List<Sound> preloadQueue = Lists.newArrayList();

    public SoundEngine(MusicManager p_427312_, SoundManager p_120236_, Options p_120237_, ResourceProvider p_249332_) {
        this.musicManager = p_427312_;
        this.soundManager = p_120236_;
        this.options = p_120237_;
        this.soundBuffers = new SoundBufferLibrary(p_249332_);
    }

    public void reload() {
        ONLY_WARN_ONCE.clear();
        for (SoundEvent $$0 : BuiltInRegistries.SOUND_EVENT) {
            ResourceLocation $$1;
            if ($$0 == SoundEvents.EMPTY || this.soundManager.getSoundEvent($$1 = $$0.location()) != null) continue;
            LOGGER.warn("Missing sound for event: {}", (Object)BuiltInRegistries.SOUND_EVENT.getKey($$0));
            ONLY_WARN_ONCE.add($$1);
        }
        this.destroy();
        this.loadLibrary();
    }

    private synchronized void loadLibrary() {
        if (this.loaded) {
            return;
        }
        try {
            String $$0 = this.options.soundDevice().get();
            this.library.init("".equals($$0) ? null : $$0, this.options.directionalAudio().get());
            this.listener.reset();
            this.listener.setGain(this.options.getSoundSourceVolume(SoundSource.MASTER));
            this.soundBuffers.preload(this.preloadQueue).thenRun(this.preloadQueue::clear);
            this.loaded = true;
            LOGGER.info(MARKER, "Sound engine started");
        }
        catch (RuntimeException $$1) {
            LOGGER.error(MARKER, "Error starting SoundSystem. Turning off sounds & music", (Throwable)$$1);
        }
    }

    private float getVolume(@Nullable SoundSource p_428781_) {
        if (p_428781_ == null || p_428781_ == SoundSource.MASTER) {
            return 1.0f;
        }
        return this.options.getSoundSourceVolume(p_428781_);
    }

    public void updateCategoryVolume(SoundSource p_120261_, float p_428780_) {
        if (!this.loaded) {
            return;
        }
        if (p_120261_ == SoundSource.MASTER) {
            this.listener.setGain(p_428780_);
            return;
        }
        if (p_120261_ == SoundSource.MUSIC && this.options.getSoundSourceVolume(SoundSource.MUSIC) > 0.0f) {
            this.musicManager.showNowPlayingToastIfNeeded();
        }
        this.instanceToChannel.forEach((p_120280_, p_120281_) -> {
            float $$2 = this.calculateVolume((SoundInstance)p_120280_);
            p_120281_.execute(p_425183_ -> p_425183_.setVolume($$2));
        });
    }

    public void destroy() {
        if (this.loaded) {
            this.stopAll();
            this.soundBuffers.clear();
            this.library.cleanup();
            this.loaded = false;
        }
    }

    public void emergencyShutdown() {
        if (this.loaded) {
            this.library.cleanup();
        }
    }

    public void stop(SoundInstance p_120275_) {
        ChannelAccess.ChannelHandle $$1;
        if (this.loaded && ($$1 = this.instanceToChannel.get(p_120275_)) != null) {
            $$1.execute(Channel::stop);
        }
    }

    public void setVolume(SoundInstance p_382891_, float p_382956_) {
        ChannelAccess.ChannelHandle $$2;
        if (this.loaded && ($$2 = this.instanceToChannel.get(p_382891_)) != null) {
            $$2.execute(p_382558_ -> p_382558_.setVolume(p_382956_ * this.calculateVolume(p_382891_)));
        }
    }

    public void stopAll() {
        if (this.loaded) {
            this.executor.flush();
            this.instanceToChannel.values().forEach(p_120288_ -> p_120288_.execute(Channel::stop));
            this.instanceToChannel.clear();
            this.channelAccess.clear();
            this.queuedSounds.clear();
            this.tickingSounds.clear();
            this.instanceBySource.clear();
            this.soundDeleteTime.clear();
            this.queuedTickableSounds.clear();
        }
    }

    public void addEventListener(SoundEventListener p_120296_) {
        this.listeners.add(p_120296_);
    }

    public void removeEventListener(SoundEventListener p_120308_) {
        this.listeners.remove(p_120308_);
    }

    private boolean shouldChangeDevice() {
        boolean $$1;
        if (this.library.isCurrentDeviceDisconnected()) {
            LOGGER.info("Audio device was lost!");
            return true;
        }
        long $$0 = Util.getMillis();
        boolean bl = $$1 = $$0 - this.lastDeviceCheckTime >= 1000L;
        if ($$1) {
            this.lastDeviceCheckTime = $$0;
            if (this.devicePoolState.compareAndSet(DeviceCheckState.NO_CHANGE, DeviceCheckState.ONGOING)) {
                String $$2 = this.options.soundDevice().get();
                Util.ioPool().execute(() -> {
                    if ("".equals($$2)) {
                        if (this.library.hasDefaultDeviceChanged()) {
                            LOGGER.info("System default audio device has changed!");
                            this.devicePoolState.compareAndSet(DeviceCheckState.ONGOING, DeviceCheckState.CHANGE_DETECTED);
                        }
                    } else if (!this.library.getCurrentDeviceName().equals($$2) && this.library.getAvailableSoundDevices().contains($$2)) {
                        LOGGER.info("Preferred audio device has become available!");
                        this.devicePoolState.compareAndSet(DeviceCheckState.ONGOING, DeviceCheckState.CHANGE_DETECTED);
                    }
                    this.devicePoolState.compareAndSet(DeviceCheckState.ONGOING, DeviceCheckState.NO_CHANGE);
                });
            }
        }
        return this.devicePoolState.compareAndSet(DeviceCheckState.CHANGE_DETECTED, DeviceCheckState.NO_CHANGE);
    }

    public void tick(boolean p_120303_) {
        if (this.shouldChangeDevice()) {
            this.reload();
        }
        if (!p_120303_) {
            this.tickInGameSound();
        } else {
            this.tickMusicWhenPaused();
        }
        this.channelAccess.scheduleTick();
    }

    private void tickInGameSound() {
        ++this.tickCount;
        this.queuedTickableSounds.stream().filter(SoundInstance::canPlaySound).forEach(this::play);
        this.queuedTickableSounds.clear();
        for (TickableSoundInstance $$0 : this.tickingSounds) {
            if (!$$0.canPlaySound()) {
                this.stop($$0);
            }
            $$0.tick();
            if ($$0.isStopped()) {
                this.stop($$0);
                continue;
            }
            float $$1 = this.calculateVolume($$0);
            float $$2 = this.calculatePitch($$0);
            Vec3 $$3 = new Vec3($$0.getX(), $$0.getY(), $$0.getZ());
            ChannelAccess.ChannelHandle $$4 = this.instanceToChannel.get($$0);
            if ($$4 == null) continue;
            $$4.execute(p_194478_ -> {
                p_194478_.setVolume($$1);
                p_194478_.setPitch($$2);
                p_194478_.setSelfPosition($$3);
            });
        }
        Iterator<Map.Entry<SoundInstance, ChannelAccess.ChannelHandle>> $$5 = this.instanceToChannel.entrySet().iterator();
        while ($$5.hasNext()) {
            int $$9;
            Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> $$6 = $$5.next();
            ChannelAccess.ChannelHandle $$7 = $$6.getValue();
            SoundInstance $$8 = $$6.getKey();
            if (!$$7.isStopped() || ($$9 = this.soundDeleteTime.get($$8).intValue()) > this.tickCount) continue;
            if (SoundEngine.shouldLoopManually($$8)) {
                this.queuedSounds.put($$8, this.tickCount + $$8.getDelay());
            }
            $$5.remove();
            LOGGER.debug(MARKER, "Removed channel {} because it's not playing anymore", (Object)$$7);
            this.soundDeleteTime.remove($$8);
            try {
                this.instanceBySource.remove((Object)$$8.getSource(), (Object)$$8);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!($$8 instanceof TickableSoundInstance)) continue;
            this.tickingSounds.remove($$8);
        }
        Iterator<Map.Entry<SoundInstance, Integer>> $$10 = this.queuedSounds.entrySet().iterator();
        while ($$10.hasNext()) {
            Map.Entry<SoundInstance, Integer> $$11 = $$10.next();
            if (this.tickCount < $$11.getValue()) continue;
            SoundInstance $$12 = $$11.getKey();
            if ($$12 instanceof TickableSoundInstance) {
                ((TickableSoundInstance)$$12).tick();
            }
            this.play($$12);
            $$10.remove();
        }
    }

    private void tickMusicWhenPaused() {
        Iterator<Map.Entry<SoundInstance, ChannelAccess.ChannelHandle>> $$0 = this.instanceToChannel.entrySet().iterator();
        while ($$0.hasNext()) {
            Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> $$1 = $$0.next();
            ChannelAccess.ChannelHandle $$2 = $$1.getValue();
            SoundInstance $$3 = $$1.getKey();
            if ($$3.getSource() != SoundSource.MUSIC || !$$2.isStopped()) continue;
            $$0.remove();
            LOGGER.debug(MARKER, "Removed channel {} because it's not playing anymore", (Object)$$2);
            this.soundDeleteTime.remove($$3);
            this.instanceBySource.remove((Object)$$3.getSource(), (Object)$$3);
        }
    }

    private static boolean requiresManualLooping(SoundInstance p_120316_) {
        return p_120316_.getDelay() > 0;
    }

    private static boolean shouldLoopManually(SoundInstance p_120319_) {
        return p_120319_.isLooping() && SoundEngine.requiresManualLooping(p_120319_);
    }

    private static boolean shouldLoopAutomatically(SoundInstance p_120322_) {
        return p_120322_.isLooping() && !SoundEngine.requiresManualLooping(p_120322_);
    }

    public boolean isActive(SoundInstance p_120306_) {
        if (!this.loaded) {
            return false;
        }
        if (this.soundDeleteTime.containsKey(p_120306_) && this.soundDeleteTime.get(p_120306_) <= this.tickCount) {
            return true;
        }
        return this.instanceToChannel.containsKey(p_120306_);
    }

    public PlayResult play(SoundInstance p_120313_) {
        if (!this.loaded) {
            return PlayResult.NOT_STARTED;
        }
        if (!p_120313_.canPlaySound()) {
            return PlayResult.NOT_STARTED;
        }
        WeighedSoundEvents $$1 = p_120313_.resolve(this.soundManager);
        ResourceLocation $$2 = p_120313_.getLocation();
        if ($$1 == null) {
            if (ONLY_WARN_ONCE.add($$2)) {
                LOGGER.warn(MARKER, "Unable to play unknown soundEvent: {}", (Object)$$2);
            }
            return PlayResult.NOT_STARTED;
        }
        Sound $$3 = p_120313_.getSound();
        if ($$3 == SoundManager.INTENTIONALLY_EMPTY_SOUND) {
            return PlayResult.NOT_STARTED;
        }
        if ($$3 == SoundManager.EMPTY_SOUND) {
            if (ONLY_WARN_ONCE.add($$2)) {
                LOGGER.warn(MARKER, "Unable to play empty soundEvent: {}", (Object)$$2);
            }
            return PlayResult.NOT_STARTED;
        }
        float $$4 = p_120313_.getVolume();
        float $$5 = Math.max($$4, 1.0f) * (float)$$3.getAttenuationDistance();
        SoundSource $$6 = p_120313_.getSource();
        float $$7 = this.calculateVolume($$4, $$6);
        float $$8 = this.calculatePitch(p_120313_);
        SoundInstance.Attenuation $$9 = p_120313_.getAttenuation();
        boolean $$10 = p_120313_.isRelative();
        if (!this.listeners.isEmpty()) {
            float $$11 = $$10 || $$9 == SoundInstance.Attenuation.NONE ? Float.POSITIVE_INFINITY : $$5;
            for (SoundEventListener $$12 : this.listeners) {
                $$12.onPlaySound(p_120313_, $$1, $$11);
            }
        }
        boolean $$13 = false;
        if ($$7 == 0.0f) {
            if (p_120313_.canStartSilent() || $$6 == SoundSource.MUSIC) {
                $$13 = true;
            } else {
                LOGGER.debug(MARKER, "Skipped playing sound {}, volume was zero.", (Object)$$3.getLocation());
                return PlayResult.NOT_STARTED;
            }
        }
        Vec3 $$14 = new Vec3(p_120313_.getX(), p_120313_.getY(), p_120313_.getZ());
        if (this.listener.getGain() <= 0.0f && $$6 != SoundSource.MUSIC) {
            LOGGER.debug(MARKER, "Skipped playing soundEvent: {}, master volume was zero", (Object)$$2);
            return PlayResult.NOT_STARTED;
        }
        boolean $$15 = SoundEngine.shouldLoopAutomatically(p_120313_);
        boolean $$16 = $$3.shouldStream();
        CompletableFuture<ChannelAccess.ChannelHandle> $$17 = this.channelAccess.createHandle($$3.shouldStream() ? Library.Pool.STREAMING : Library.Pool.STATIC);
        ChannelAccess.ChannelHandle $$18 = $$17.join();
        if ($$18 == null) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                LOGGER.warn("Failed to create new sound handle");
            }
            return PlayResult.NOT_STARTED;
        }
        LOGGER.debug(MARKER, "Playing sound {} for event {}", (Object)$$3.getLocation(), (Object)$$2);
        this.soundDeleteTime.put(p_120313_, this.tickCount + 20);
        this.instanceToChannel.put(p_120313_, $$18);
        this.instanceBySource.put((Object)$$6, (Object)p_120313_);
        $$18.execute(p_194488_ -> {
            p_194488_.setPitch($$8);
            p_194488_.setVolume($$7);
            if ($$9 == SoundInstance.Attenuation.LINEAR) {
                p_194488_.linearAttenuation($$5);
            } else {
                p_194488_.disableAttenuation();
            }
            p_194488_.setLooping($$15 && !$$16);
            p_194488_.setSelfPosition($$14);
            p_194488_.setRelative($$10);
        });
        if (!$$16) {
            this.soundBuffers.getCompleteBuffer($$3.getPath()).thenAccept(p_383126_ -> $$18.execute(p_194495_ -> {
                p_194495_.attachStaticBuffer((SoundBuffer)p_383126_);
                p_194495_.play();
            }));
        } else {
            this.soundBuffers.getStream($$3.getPath(), $$15).thenAccept(p_383033_ -> $$18.execute(p_194498_ -> {
                p_194498_.attachBufferStream((AudioStream)p_383033_);
                p_194498_.play();
            }));
        }
        if (p_120313_ instanceof TickableSoundInstance) {
            this.tickingSounds.add((TickableSoundInstance)p_120313_);
        }
        if ($$13) {
            return PlayResult.STARTED_SILENTLY;
        }
        return PlayResult.STARTED;
    }

    public void queueTickingSound(TickableSoundInstance p_120283_) {
        this.queuedTickableSounds.add(p_120283_);
    }

    public void requestPreload(Sound p_120273_) {
        this.preloadQueue.add(p_120273_);
    }

    private float calculatePitch(SoundInstance p_120325_) {
        return Mth.clamp(p_120325_.getPitch(), 0.5f, 2.0f);
    }

    private float calculateVolume(SoundInstance p_120328_) {
        return this.calculateVolume(p_120328_.getVolume(), p_120328_.getSource());
    }

    private float calculateVolume(float p_235258_, SoundSource p_235259_) {
        return Mth.clamp(p_235258_ * this.getVolume(p_235259_), 0.0f, 1.0f);
    }

    public void pauseAllExcept(SoundSource ... p_425836_) {
        if (!this.loaded) {
            return;
        }
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> $$1 : this.instanceToChannel.entrySet()) {
            if (List.of(p_425836_).contains((Object)$$1.getKey().getSource())) continue;
            $$1.getValue().execute(Channel::pause);
        }
    }

    public void resume() {
        if (this.loaded) {
            this.channelAccess.executeOnChannels(p_194510_ -> p_194510_.forEach(Channel::unpause));
        }
    }

    public void playDelayed(SoundInstance p_120277_, int p_120278_) {
        this.queuedSounds.put(p_120277_, this.tickCount + p_120278_);
    }

    public void updateSource(Camera p_120271_) {
        if (!this.loaded || !p_120271_.isInitialized()) {
            return;
        }
        ListenerTransform $$1 = new ListenerTransform(p_120271_.getPosition(), new Vec3(p_120271_.getLookVector()), new Vec3(p_120271_.getUpVector()));
        this.executor.execute(() -> this.listener.setTransform($$1));
    }

    public void stop(@Nullable ResourceLocation p_120300_, @Nullable SoundSource p_120301_) {
        if (p_120301_ != null) {
            for (SoundInstance $$2 : this.instanceBySource.get((Object)p_120301_)) {
                if (p_120300_ != null && !$$2.getLocation().equals(p_120300_)) continue;
                this.stop($$2);
            }
        } else if (p_120300_ == null) {
            this.stopAll();
        } else {
            for (SoundInstance $$3 : this.instanceToChannel.keySet()) {
                if (!$$3.getLocation().equals(p_120300_)) continue;
                this.stop($$3);
            }
        }
    }

    public String getDebugString() {
        return this.library.getDebugString();
    }

    public List<String> getAvailableSoundDevices() {
        return this.library.getAvailableSoundDevices();
    }

    public ListenerTransform getListenerTransform() {
        return this.listener.getTransform();
    }

    static enum DeviceCheckState {
        ONGOING,
        CHANGE_DETECTED,
        NO_CHANGE;

    }

    public static enum PlayResult {
        STARTED,
        STARTED_SILENTLY,
        NOT_STARTED;

    }
}

