/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicInfo;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.OptionEnum;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;

public class MusicManager {
    private static final int STARTING_DELAY = 100;
    private final RandomSource random = RandomSource.create();
    private final Minecraft minecraft;
    @Nullable
    private SoundInstance currentMusic;
    private MusicFrequency gameMusicFrequency;
    private float currentGain = 1.0f;
    private int nextSongDelay = 100;
    private boolean toastShown = false;

    public MusicManager(Minecraft p_120182_) {
        this.minecraft = p_120182_;
        this.gameMusicFrequency = p_120182_.options.musicFrequency().get();
    }

    public void tick() {
        boolean $$2;
        MusicInfo $$0 = this.minecraft.getSituationalMusic();
        float $$1 = $$0.volume();
        if (this.currentMusic != null && this.currentGain != $$1 && !($$2 = this.fadePlaying($$1))) {
            return;
        }
        Music $$3 = $$0.music();
        if ($$3 == null) {
            this.nextSongDelay = Math.max(this.nextSongDelay, 100);
            return;
        }
        if (this.currentMusic != null) {
            if ($$0.canReplace(this.currentMusic)) {
                this.minecraft.getSoundManager().stop(this.currentMusic);
                this.nextSongDelay = Mth.nextInt(this.random, 0, $$3.minDelay() / 2);
            }
            if (!this.minecraft.getSoundManager().isActive(this.currentMusic)) {
                this.currentMusic = null;
                this.nextSongDelay = Math.min(this.nextSongDelay, this.gameMusicFrequency.getNextSongDelay($$3, this.random));
            }
        }
        this.nextSongDelay = Math.min(this.nextSongDelay, this.gameMusicFrequency.getNextSongDelay($$3, this.random));
        if (this.currentMusic == null && this.nextSongDelay-- <= 0) {
            this.startPlaying($$0);
        }
    }

    public void startPlaying(MusicInfo p_383115_) {
        SoundEvent $$1 = p_383115_.music().event().value();
        this.currentMusic = SimpleSoundInstance.forMusic($$1, p_383115_.volume());
        switch (this.minecraft.getSoundManager().play(this.currentMusic)) {
            case STARTED: {
                this.minecraft.getToastManager().showNowPlayingToast();
                this.toastShown = true;
                break;
            }
            case STARTED_SILENTLY: {
                this.toastShown = false;
            }
        }
        this.nextSongDelay = Integer.MAX_VALUE;
        this.currentGain = p_383115_.volume();
    }

    public void showNowPlayingToastIfNeeded() {
        if (!this.toastShown) {
            this.minecraft.getToastManager().showNowPlayingToast();
            this.toastShown = true;
        }
    }

    public void stopPlaying(Music p_278295_) {
        if (this.isPlayingMusic(p_278295_)) {
            this.stopPlaying();
        }
    }

    public void stopPlaying() {
        if (this.currentMusic != null) {
            this.minecraft.getSoundManager().stop(this.currentMusic);
            this.currentMusic = null;
            this.minecraft.getToastManager().hideNowPlayingToast();
        }
        this.nextSongDelay += 100;
    }

    private boolean fadePlaying(float p_383118_) {
        if (this.currentMusic == null) {
            return false;
        }
        if (this.currentGain == p_383118_) {
            return true;
        }
        if (this.currentGain < p_383118_) {
            this.currentGain += Mth.clamp(this.currentGain, 5.0E-4f, 0.005f);
            if (this.currentGain > p_383118_) {
                this.currentGain = p_383118_;
            }
        } else {
            this.currentGain = 0.03f * p_383118_ + 0.97f * this.currentGain;
            if (Math.abs(this.currentGain - p_383118_) < 1.0E-4f || this.currentGain < p_383118_) {
                this.currentGain = p_383118_;
            }
        }
        this.currentGain = Mth.clamp(this.currentGain, 0.0f, 1.0f);
        if (this.currentGain <= 1.0E-4f) {
            this.stopPlaying();
            return false;
        }
        this.minecraft.getSoundManager().setVolume(this.currentMusic, this.currentGain);
        return true;
    }

    public boolean isPlayingMusic(Music p_120188_) {
        if (this.currentMusic == null) {
            return false;
        }
        return p_120188_.event().value().location().equals(this.currentMusic.getLocation());
    }

    @Nullable
    public String getCurrentMusicTranslationKey() {
        Sound $$0;
        if (this.currentMusic != null && ($$0 = this.currentMusic.getSound()) != null) {
            return $$0.getLocation().toShortLanguageKey();
        }
        return null;
    }

    public void setMinutesBetweenSongs(MusicFrequency p_426207_) {
        this.gameMusicFrequency = p_426207_;
        this.nextSongDelay = this.gameMusicFrequency.getNextSongDelay(this.minecraft.getSituationalMusic().music(), this.random);
    }

    public static enum MusicFrequency implements OptionEnum,
    StringRepresentable
    {
        DEFAULT(20),
        FREQUENT(10),
        CONSTANT(0);

        public static final Codec<MusicFrequency> CODEC;
        private static final String KEY_PREPEND = "options.music_frequency.";
        private final int id;
        private final int maxFrequency;
        private final String key;

        private MusicFrequency(int p_426299_) {
            this.id = p_426299_;
            this.maxFrequency = p_426299_ * 1200;
            this.key = KEY_PREPEND + this.name().toLowerCase();
        }

        int getNextSongDelay(@Nullable Music p_425869_, RandomSource p_426254_) {
            if (p_425869_ == null) {
                return this.maxFrequency;
            }
            if (this == CONSTANT) {
                return 100;
            }
            int $$2 = Math.min(p_425869_.minDelay(), this.maxFrequency);
            int $$3 = Math.min(p_425869_.maxDelay(), this.maxFrequency);
            return Mth.nextInt(p_426254_, $$2, $$3);
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(MusicFrequency::values);
        }
    }
}

