/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.server;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class IntegratedPlayerList
extends PlayerList {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private CompoundTag playerData;

    public IntegratedPlayerList(IntegratedServer p_251269_, LayeredRegistryAccess<RegistryLayer> p_250644_, PlayerDataStorage p_249022_) {
        super(p_251269_, p_250644_, p_249022_, 8);
        this.setViewDistance(10);
    }

    @Override
    protected void save(ServerPlayer p_120011_) {
        if (this.getServer().isSingleplayerOwner(p_120011_.getGameProfile())) {
            try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector(p_120011_.problemPath(), LOGGER);){
                TagValueOutput $$2 = TagValueOutput.createWithContext($$1, p_120011_.registryAccess());
                p_120011_.saveWithoutId($$2);
                this.playerData = $$2.buildResult();
            }
        }
        super.save(p_120011_);
    }

    @Override
    public Component canPlayerLogin(SocketAddress p_120007_, GameProfile p_120008_) {
        if (this.getServer().isSingleplayerOwner(p_120008_) && this.getPlayerByName(p_120008_.getName()) != null) {
            return Component.translatable("multiplayer.disconnect.name_taken");
        }
        return super.canPlayerLogin(p_120007_, p_120008_);
    }

    @Override
    public IntegratedServer getServer() {
        return (IntegratedServer)super.getServer();
    }

    @Override
    @Nullable
    public CompoundTag getSingleplayerData() {
        return this.playerData;
    }

    @Override
    public /* synthetic */ MinecraftServer getServer() {
        return this.getServer();
    }
}

