/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientRegistryLayer;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.PlaceholderLookupProvider;
import net.minecraft.util.StrictJsonParser;
import org.slf4j.Logger;

public class ClientItemInfoLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter LISTER = FileToIdConverter.json("items");

    public static CompletableFuture<LoadedClientInfos> scheduleLoad(ResourceManager p_390398_, Executor p_390441_) {
        RegistryAccess.Frozen $$2 = ClientRegistryLayer.createRegistryAccess().compositeAccess();
        return CompletableFuture.supplyAsync(() -> LISTER.listMatchingResources(p_390398_), p_390441_).thenCompose(p_399357_ -> {
            ArrayList $$3 = new ArrayList(p_399357_.size());
            p_399357_.forEach((p_399361_, p_399362_) -> $$3.add(CompletableFuture.supplyAsync(() -> {
                PendingLoad pendingLoad;
                block8: {
                    ResourceLocation $$3 = LISTER.fileToId((ResourceLocation)p_399361_);
                    BufferedReader $$4 = p_399362_.openAsReader();
                    try {
                        PlaceholderLookupProvider $$5 = new PlaceholderLookupProvider($$2);
                        RegistryOps $$6 = $$5.createSerializationContext(JsonOps.INSTANCE);
                        ClientItem $$7 = ClientItem.CODEC.parse($$6, (Object)StrictJsonParser.parse($$4)).ifError(p_390349_ -> LOGGER.error("Couldn't parse item model '{}' from pack '{}': {}", new Object[]{$$3, p_399362_.sourcePackId(), p_390349_.message()})).result().map(p_399364_ -> {
                            if ($$5.hasRegisteredPlaceholders()) {
                                return p_399364_.withRegistrySwapper($$5.createSwapper());
                            }
                            return p_399364_;
                        }).orElse(null);
                        pendingLoad = new PendingLoad($$3, $$7);
                        if ($$4 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if ($$4 != null) {
                                try {
                                    ((Reader)$$4).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception $$8) {
                            LOGGER.error("Failed to open item model {} from pack '{}'", new Object[]{p_399361_, p_399362_.sourcePackId(), $$8});
                            return new PendingLoad($$3, null);
                        }
                    }
                    ((Reader)$$4).close();
                }
                return pendingLoad;
            }, p_390441_)));
            return Util.sequence($$3).thenApply(p_390406_ -> {
                HashMap<ResourceLocation, ClientItem> $$1 = new HashMap<ResourceLocation, ClientItem>();
                for (PendingLoad $$2 : p_390406_) {
                    if ($$2.clientItemInfo == null) continue;
                    $$1.put($$2.id, $$2.clientItemInfo);
                }
                return new LoadedClientInfos($$1);
            });
        });
    }

    record PendingLoad(ResourceLocation id, @Nullable ClientItem clientItemInfo) {
    }

    public record LoadedClientInfos(Map<ResourceLocation, ClientItem> contents) {
    }
}

