/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quadrant;
import com.mojang.math.Transformation;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockMath;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public enum BlockModelRotation implements ModelState
{
    X0_Y0(Quadrant.R0, Quadrant.R0),
    X0_Y90(Quadrant.R0, Quadrant.R90),
    X0_Y180(Quadrant.R0, Quadrant.R180),
    X0_Y270(Quadrant.R0, Quadrant.R270),
    X90_Y0(Quadrant.R90, Quadrant.R0),
    X90_Y90(Quadrant.R90, Quadrant.R90),
    X90_Y180(Quadrant.R90, Quadrant.R180),
    X90_Y270(Quadrant.R90, Quadrant.R270),
    X180_Y0(Quadrant.R180, Quadrant.R0),
    X180_Y90(Quadrant.R180, Quadrant.R90),
    X180_Y180(Quadrant.R180, Quadrant.R180),
    X180_Y270(Quadrant.R180, Quadrant.R270),
    X270_Y0(Quadrant.R270, Quadrant.R0),
    X270_Y90(Quadrant.R270, Quadrant.R90),
    X270_Y180(Quadrant.R270, Quadrant.R180),
    X270_Y270(Quadrant.R270, Quadrant.R270);

    private static final BlockModelRotation[][] XY_TABLE;
    private final Quadrant xRotation;
    private final Quadrant yRotation;
    final Transformation transformation;
    private final OctahedralGroup actualRotation;
    final Map<Direction, Matrix4fc> faceMapping = new EnumMap<Direction, Matrix4fc>(Direction.class);
    final Map<Direction, Matrix4fc> inverseFaceMapping = new EnumMap<Direction, Matrix4fc>(Direction.class);
    private final WithUvLock withUvLock = new WithUvLock(this);

    private BlockModelRotation(Quadrant p_405293_, Quadrant p_404633_) {
        this.xRotation = p_405293_;
        this.yRotation = p_404633_;
        this.actualRotation = OctahedralGroup.fromXYAngles(p_405293_, p_404633_);
        this.transformation = this.actualRotation != OctahedralGroup.IDENTITY ? new Transformation((Matrix4fc)new Matrix4f(this.actualRotation.transformation())) : Transformation.identity();
        for (Direction $$2 : Direction.values()) {
            Matrix4fc $$3 = BlockMath.getFaceTransformation(this.transformation, $$2).getMatrix();
            this.faceMapping.put($$2, $$3);
            this.inverseFaceMapping.put($$2, (Matrix4fc)$$3.invertAffine(new Matrix4f()));
        }
    }

    @Override
    public Transformation transformation() {
        return this.transformation;
    }

    public static BlockModelRotation by(Quadrant p_405164_, Quadrant p_405562_) {
        return XY_TABLE[p_405164_.ordinal()][p_405562_.ordinal()];
    }

    public OctahedralGroup actualRotation() {
        return this.actualRotation;
    }

    public ModelState withUvLock() {
        return this.withUvLock;
    }

    static {
        XY_TABLE = Util.make(new BlockModelRotation[Quadrant.values().length][Quadrant.values().length], p_404104_ -> {
            BlockModelRotation[] blockModelRotationArray = BlockModelRotation.values();
            int n = blockModelRotationArray.length;
            for (int i = 0; i < n; ++i) {
                BlockModelRotation $$1;
                p_404104_[$$1.xRotation.ordinal()][$$1.yRotation.ordinal()] = $$1 = blockModelRotationArray[i];
            }
        });
    }

    record WithUvLock(BlockModelRotation parent) implements ModelState
    {
        @Override
        public Transformation transformation() {
            return this.parent.transformation;
        }

        @Override
        public Matrix4fc faceTransformation(Direction p_405486_) {
            return this.parent.faceMapping.getOrDefault(p_405486_, NO_TRANSFORM);
        }

        @Override
        public Matrix4fc inverseFaceTransformation(Direction p_404754_) {
            return this.parent.inverseFaceMapping.getOrDefault(p_404754_, NO_TRANSFORM);
        }
    }
}

