/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapTextureManager
implements AutoCloseable {
    private final Int2ObjectMap<MapInstance> maps = new Int2ObjectOpenHashMap();
    final TextureManager textureManager;

    public MapTextureManager(TextureManager p_364440_) {
        this.textureManager = p_364440_;
    }

    public void update(MapId p_360802_, MapItemSavedData p_362966_) {
        this.getOrCreateMapInstance(p_360802_, p_362966_).forceUpload();
    }

    public ResourceLocation prepareMapTexture(MapId p_364272_, MapItemSavedData p_364454_) {
        MapInstance $$2 = this.getOrCreateMapInstance(p_364272_, p_364454_);
        $$2.updateTextureIfNeeded();
        return $$2.location;
    }

    public void resetData() {
        for (MapInstance $$0 : this.maps.values()) {
            $$0.close();
        }
        this.maps.clear();
    }

    private MapInstance getOrCreateMapInstance(MapId p_360665_, MapItemSavedData p_363475_) {
        return (MapInstance)this.maps.compute(p_360665_.id(), (p_362953_, p_362729_) -> {
            if (p_362729_ == null) {
                return new MapInstance(this, (int)p_362953_, p_363475_);
            }
            p_362729_.replaceMapData(p_363475_);
            return p_362729_;
        });
    }

    @Override
    public void close() {
        this.resetData();
    }

    class MapInstance
    implements AutoCloseable {
        private MapItemSavedData data;
        private final DynamicTexture texture;
        private boolean requiresUpload = true;
        final ResourceLocation location;

        MapInstance(MapTextureManager mapTextureManager, int p_362268_, MapItemSavedData p_362707_) {
            this.data = p_362707_;
            this.texture = new DynamicTexture(() -> "Map " + p_362268_, 128, 128, true);
            this.location = ResourceLocation.withDefaultNamespace("map/" + p_362268_);
            mapTextureManager.textureManager.register(this.location, this.texture);
        }

        void replaceMapData(MapItemSavedData p_361304_) {
            boolean $$1 = this.data != p_361304_;
            this.data = p_361304_;
            this.requiresUpload |= $$1;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        void updateTextureIfNeeded() {
            if (this.requiresUpload) {
                NativeImage $$0 = this.texture.getPixels();
                if ($$0 != null) {
                    for (int $$1 = 0; $$1 < 128; ++$$1) {
                        for (int $$2 = 0; $$2 < 128; ++$$2) {
                            int $$3 = $$2 + $$1 * 128;
                            $$0.setPixel($$2, $$1, MapColor.getColorFromPackedId(this.data.colors[$$3]));
                        }
                    }
                }
                this.texture.upload();
                this.requiresUpload = false;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

