/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.ARGB;
import org.slf4j.Logger;

public record PalettedPermutations(List<ResourceLocation> textures, ResourceLocation paletteKey, Map<String, ResourceLocation> permutations, String separator) implements SpriteSource
{
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String DEFAULT_SEPARATOR = "_";
    public static final MapCodec<PalettedPermutations> MAP_CODEC = RecordCodecBuilder.mapCodec(p_399351_ -> p_399351_.group((App)Codec.list(ResourceLocation.CODEC).fieldOf("textures").forGetter(PalettedPermutations::textures), (App)ResourceLocation.CODEC.fieldOf("palette_key").forGetter(PalettedPermutations::paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, ResourceLocation.CODEC).fieldOf("permutations").forGetter(PalettedPermutations::permutations), (App)Codec.STRING.optionalFieldOf("separator", (Object)DEFAULT_SEPARATOR).forGetter(PalettedPermutations::separator)).apply((Applicative)p_399351_, PalettedPermutations::new));

    public PalettedPermutations(List<ResourceLocation> p_267282_, ResourceLocation p_266681_, Map<String, ResourceLocation> p_266741_) {
        this(p_267282_, p_266681_, p_266741_, DEFAULT_SEPARATOR);
    }

    @Override
    public void run(ResourceManager p_267219_, SpriteSource.Output p_267250_) {
        Supplier $$2 = Suppliers.memoize(() -> PalettedPermutations.loadPaletteEntryFromImage(p_267219_, this.paletteKey));
        HashMap $$3 = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> PalettedPermutations.lambda$run$3($$3, (java.util.function.Supplier)$$2, p_267219_, arg_0, arg_1));
        for (ResourceLocation $$4 : this.textures) {
            ResourceLocation $$5 = TEXTURE_ID_CONVERTER.idToFile($$4);
            Optional<Resource> $$6 = p_267219_.getResource($$5);
            if ($$6.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)$$5);
                continue;
            }
            LazyLoadedImage $$7 = new LazyLoadedImage($$5, $$6.get(), $$3.size());
            for (Map.Entry $$8 : $$3.entrySet()) {
                ResourceLocation $$9 = $$4.withSuffix(this.separator + (String)$$8.getKey());
                p_267250_.add($$9, new PalettedSpriteSupplier($$7, (java.util.function.Supplier)$$8.getValue(), $$9));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap $$2 = new Int2IntOpenHashMap(p_266776_.length);
        for (int $$3 = 0; $$3 < p_266839_.length; ++$$3) {
            int $$4 = p_266839_[$$3];
            if (ARGB.alpha($$4) == 0) continue;
            $$2.put(ARGB.transparent($$4), p_266776_[$$3]);
        }
        return arg_0 -> PalettedPermutations.lambda$createPaletteMapping$4((Int2IntMap)$$2, arg_0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[] loadPaletteEntryFromImage(ResourceManager p_267184_, ResourceLocation p_267059_) {
        Optional<Resource> $$2 = p_267184_.getResource(TEXTURE_ID_CONVERTER.idToFile(p_267059_));
        if ($$2.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)p_267059_);
            throw new IllegalArgumentException();
        }
        try (InputStream $$3 = $$2.get().open();){
            NativeImage $$4 = NativeImage.read($$3);
            try {
                int[] nArray = $$4.getPixels();
                if ($$4 != null) {
                    $$4.close();
                }
                return nArray;
            }
            catch (Throwable throwable) {
                if ($$4 != null) {
                    try {
                        $$4.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Exception $$5) {
            LOGGER.error("Couldn't load texture {}", (Object)p_267059_, (Object)$$5);
            throw new IllegalArgumentException();
        }
    }

    public MapCodec<PalettedPermutations> codec() {
        return MAP_CODEC;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$4(Int2IntMap p_359294_, int p_359295_) {
        int $$2 = ARGB.alpha(p_359295_);
        if ($$2 == 0) {
            return p_359295_;
        }
        int $$3 = ARGB.transparent(p_359295_);
        int $$4 = p_359294_.getOrDefault($$3, ARGB.opaque($$3));
        int $$5 = ARGB.alpha($$4);
        return ARGB.color($$2 * $$5 / 255, $$4);
    }

    private static /* synthetic */ void lambda$run$3(Map p_266771_, java.util.function.Supplier p_266716_, ResourceManager p_266763_, String p_267108_, ResourceLocation p_266969_) {
        p_266771_.put(p_267108_, Suppliers.memoize(() -> PalettedPermutations.lambda$run$2((java.util.function.Supplier)p_266716_, p_266763_, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$2(java.util.function.Supplier p_267012_, ResourceManager p_266968_, ResourceLocation p_267020_) {
        return PalettedPermutations.createPaletteMapping((int[])p_267012_.get(), PalettedPermutations.loadPaletteEntryFromImage(p_266968_, p_267020_));
    }

    record PalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> palette, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public SpriteContents apply(SpriteResourceLoader p_295023_) {
            try {
                NativeImage $$1 = this.baseImage.get().mappedCopy(this.palette.get());
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize($$1.getWidth(), $$1.getHeight()), $$1, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException $$2) {
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)$$2);
                SpriteContents spriteContents = null;
                return spriteContents;
            }
            finally {
                this.baseImage.release();
            }
        }

        @Override
        public void discard() {
            this.baseImage.release();
        }

        @Override
        @Nullable
        public /* synthetic */ Object apply(Object object) {
            return this.apply((SpriteResourceLoader)object);
        }
    }
}

