/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.Zone;
import org.slf4j.Logger;

public class SpriteLoader {
    public static final Set<MetadataSectionType<?>> DEFAULT_METADATA_SECTIONS = Set.of(AnimationMetadataSection.TYPE);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation location;
    private final int maxSupportedTextureSize;
    private final int minWidth;
    private final int minHeight;

    public SpriteLoader(ResourceLocation p_276126_, int p_276121_, int p_276110_, int p_276114_) {
        this.location = p_276126_;
        this.maxSupportedTextureSize = p_276121_;
        this.minWidth = p_276110_;
        this.minHeight = p_276114_;
    }

    public static SpriteLoader create(TextureAtlas p_249085_) {
        return new SpriteLoader(p_249085_.location(), p_249085_.maxSupportedTextureSize(), p_249085_.getWidth(), p_249085_.getHeight());
    }

    public Preparations stitch(List<SpriteContents> p_262029_, int p_261919_, Executor p_261665_) {
        try (Zone $$3 = Profiler.get().zone(() -> "stitch " + String.valueOf(this.location));){
            CompletableFuture<Object> $$22;
            int $$13;
            int $$4 = this.maxSupportedTextureSize;
            Stitcher<SpriteContents> $$5 = new Stitcher<SpriteContents>($$4, $$4, p_261919_);
            int $$6 = Integer.MAX_VALUE;
            int $$7 = 1 << p_261919_;
            for (SpriteContents $$8 : p_262029_) {
                $$6 = Math.min($$6, Math.min($$8.width(), $$8.height()));
                int $$9 = Math.min(Integer.lowestOneBit($$8.width()), Integer.lowestOneBit($$8.height()));
                if ($$9 < $$7) {
                    LOGGER.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{$$8.name(), $$8.width(), $$8.height(), Mth.log2($$7), Mth.log2($$9)});
                    $$7 = $$9;
                }
                $$5.registerSprite($$8);
            }
            int $$10 = Math.min($$6, $$7);
            int $$11 = Mth.log2($$10);
            if ($$11 < p_261919_) {
                LOGGER.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.location, p_261919_, $$11, $$10});
                int $$12 = $$11;
            } else {
                $$13 = p_261919_;
            }
            try {
                $$5.stitch();
            }
            catch (StitcherException $$14) {
                CrashReport $$15 = CrashReport.forThrowable($$14, "Stitching");
                CrashReportCategory $$16 = $$15.addCategory("Stitcher");
                $$16.setDetail("Sprites", $$14.getAllSprites().stream().map(p_249576_ -> String.format(Locale.ROOT, "%s[%dx%d]", p_249576_.name(), p_249576_.width(), p_249576_.height())).collect(Collectors.joining(",")));
                $$16.setDetail("Max Texture Size", $$4);
                throw new ReportedException($$15);
            }
            int $$17 = Math.max($$5.getWidth(), this.minWidth);
            int $$18 = Math.max($$5.getHeight(), this.minHeight);
            Map<ResourceLocation, TextureAtlasSprite> $$19 = this.getStitchedSprites($$5, $$17, $$18);
            TextureAtlasSprite $$20 = $$19.get(MissingTextureAtlasSprite.getLocation());
            if ($$13 > 0) {
                CompletableFuture<Void> $$21 = CompletableFuture.runAsync(() -> $$19.values().forEach(p_251202_ -> p_251202_.contents().increaseMipLevel($$13)), p_261665_);
            } else {
                $$22 = CompletableFuture.completedFuture(null);
            }
            Preparations preparations = new Preparations($$17, $$18, $$13, $$20, $$19, $$22);
            return preparations;
        }
    }

    public static CompletableFuture<List<SpriteContents>> runSpriteSuppliers(SpriteResourceLoader p_294961_, List<Function<SpriteResourceLoader, SpriteContents>> p_261516_, Executor p_261791_) {
        List<CompletableFuture> $$3 = p_261516_.stream().map(p_293678_ -> CompletableFuture.supplyAsync(() -> (SpriteContents)p_293678_.apply(p_294961_), p_261791_)).toList();
        return Util.sequence($$3).thenApply(p_252234_ -> p_252234_.stream().filter(Objects::nonNull).toList());
    }

    public CompletableFuture<Preparations> loadAndStitch(ResourceManager p_262108_, ResourceLocation p_261754_, int p_262104_, Executor p_261687_) {
        return this.loadAndStitch(p_262108_, p_261754_, p_262104_, p_261687_, DEFAULT_METADATA_SECTIONS);
    }

    public CompletableFuture<Preparations> loadAndStitch(ResourceManager p_295469_, ResourceLocation p_294925_, int p_294855_, Executor p_294720_, Collection<MetadataSectionType<?>> p_294816_) {
        SpriteResourceLoader $$5 = SpriteResourceLoader.create(p_294816_);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SpriteSourceList.load(p_295469_, p_294925_).list(p_295469_), p_294720_).thenCompose(p_293671_ -> SpriteLoader.runSpriteSuppliers($$5, p_293671_, p_294720_))).thenApply(p_261393_ -> this.stitch((List<SpriteContents>)p_261393_, p_294855_, p_294720_));
    }

    private Map<ResourceLocation, TextureAtlasSprite> getStitchedSprites(Stitcher<SpriteContents> p_276117_, int p_276111_, int p_276112_) {
        HashMap<ResourceLocation, TextureAtlasSprite> $$3 = new HashMap<ResourceLocation, TextureAtlasSprite>();
        p_276117_.gatherSprites((p_251421_, p_250533_, p_251913_) -> $$3.put(p_251421_.name(), new TextureAtlasSprite(this.location, (SpriteContents)p_251421_, p_276111_, p_276112_, p_250533_, p_251913_)));
        return $$3;
    }

    public record Preparations(int width, int height, int mipLevel, TextureAtlasSprite missing, Map<ResourceLocation, TextureAtlasSprite> regions, CompletableFuture<Void> readyForUpload) {
        public CompletableFuture<Preparations> waitForUpload() {
            return this.readyForUpload.thenApply(p_249056_ -> this);
        }
    }
}

