/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.ARGB;
import org.slf4j.Logger;

public class SpriteContents
implements Stitcher.Entry,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation name;
    final int width;
    final int height;
    private final NativeImage originalImage;
    NativeImage[] byMipLevel;
    @Nullable
    private final AnimatedTexture animatedTexture;
    private final ResourceMetadata metadata;

    public SpriteContents(ResourceLocation p_249787_, FrameSize p_251031_, NativeImage p_252131_, ResourceMetadata p_294742_) {
        this.name = p_249787_;
        this.width = p_251031_.width();
        this.height = p_251031_.height();
        this.metadata = p_294742_;
        this.animatedTexture = p_294742_.getSection(AnimationMetadataSection.TYPE).map(p_389349_ -> this.createAnimatedTexture(p_251031_, p_252131_.getWidth(), p_252131_.getHeight(), (AnimationMetadataSection)p_389349_)).orElse(null);
        this.originalImage = p_252131_;
        this.byMipLevel = new NativeImage[]{this.originalImage};
    }

    public void increaseMipLevel(int p_248864_) {
        try {
            this.byMipLevel = MipmapGenerator.generateMipLevels(this.byMipLevel, p_248864_);
        }
        catch (Throwable $$1) {
            CrashReport $$2 = CrashReport.forThrowable($$1, "Generating mipmaps for frame");
            CrashReportCategory $$3 = $$2.addCategory("Sprite being mipmapped");
            $$3.setDetail("First frame", () -> {
                StringBuilder $$0 = new StringBuilder();
                if ($$0.length() > 0) {
                    $$0.append(", ");
                }
                $$0.append(this.originalImage.getWidth()).append("x").append(this.originalImage.getHeight());
                return $$0.toString();
            });
            CrashReportCategory $$4 = $$2.addCategory("Frame being iterated");
            $$4.setDetail("Sprite name", this.name);
            $$4.setDetail("Sprite size", () -> this.width + " x " + this.height);
            $$4.setDetail("Sprite frames", () -> this.getFrameCount() + " frames");
            $$4.setDetail("Mipmap levels", p_248864_);
            throw new ReportedException($$2);
        }
    }

    private int getFrameCount() {
        return this.animatedTexture != null ? this.animatedTexture.frames.size() : 1;
    }

    @Nullable
    private AnimatedTexture createAnimatedTexture(FrameSize p_250817_, int p_249792_, int p_252353_, AnimationMetadataSection p_250947_) {
        ArrayList<FrameInfo> $$11;
        int $$4 = p_249792_ / p_250817_.width();
        int $$5 = p_252353_ / p_250817_.height();
        int $$6 = $$4 * $$5;
        int $$7 = p_250947_.defaultFrameTime();
        if (p_250947_.frames().isEmpty()) {
            ArrayList<FrameInfo> $$8 = new ArrayList<FrameInfo>($$6);
            for (int $$9 = 0; $$9 < $$6; ++$$9) {
                $$8.add(new FrameInfo($$9, $$7));
            }
        } else {
            List<AnimationFrame> $$10 = p_250947_.frames().get();
            $$11 = new ArrayList<FrameInfo>($$10.size());
            for (AnimationFrame $$12 : $$10) {
                $$11.add(new FrameInfo($$12.index(), $$12.timeOr($$7)));
            }
            int $$13 = 0;
            IntOpenHashSet $$14 = new IntOpenHashSet();
            Iterator $$15 = $$11.iterator();
            while ($$15.hasNext()) {
                FrameInfo $$16 = (FrameInfo)$$15.next();
                boolean $$17 = true;
                if ($$16.time <= 0) {
                    LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.name, $$13, $$16.time});
                    $$17 = false;
                }
                if ($$16.index < 0 || $$16.index >= $$6) {
                    LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.name, $$13, $$16.index});
                    $$17 = false;
                }
                if ($$17) {
                    $$14.add($$16.index);
                } else {
                    $$15.remove();
                }
                ++$$13;
            }
            int[] $$18 = IntStream.range(0, $$6).filter(arg_0 -> SpriteContents.lambda$createAnimatedTexture$4((IntSet)$$14, arg_0)).toArray();
            if ($$18.length > 0) {
                LOGGER.warn("Unused frames in sprite {}: {}", (Object)this.name, (Object)Arrays.toString($$18));
            }
        }
        if ($$11.size() <= 1) {
            return null;
        }
        return new AnimatedTexture(List.copyOf($$11), $$4, p_250947_.interpolatedFrames());
    }

    void upload(int p_248895_, int p_250245_, int p_250458_, int p_251337_, NativeImage[] p_248825_, GpuTexture p_404943_) {
        for (int $$6 = 0; $$6 < this.byMipLevel.length; ++$$6) {
            RenderSystem.getDevice().createCommandEncoder().writeToTexture(p_404943_, p_248825_[$$6], $$6, 0, p_248895_ >> $$6, p_250245_ >> $$6, this.width >> $$6, this.height >> $$6, p_250458_ >> $$6, p_251337_ >> $$6);
        }
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public ResourceLocation name() {
        return this.name;
    }

    public IntStream getUniqueFrames() {
        return this.animatedTexture != null ? this.animatedTexture.getUniqueFrames() : IntStream.of(1);
    }

    @Nullable
    public SpriteTicker createTicker() {
        return this.animatedTexture != null ? this.animatedTexture.createTicker() : null;
    }

    public ResourceMetadata metadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        for (NativeImage $$0 : this.byMipLevel) {
            $$0.close();
        }
    }

    public String toString() {
        return "SpriteContents{name=" + String.valueOf(this.name) + ", frameCount=" + this.getFrameCount() + ", height=" + this.height + ", width=" + this.width + "}";
    }

    public boolean isTransparent(int p_250374_, int p_250934_, int p_249573_) {
        int $$3 = p_250934_;
        int $$4 = p_249573_;
        if (this.animatedTexture != null) {
            $$3 += this.animatedTexture.getFrameX(p_250374_) * this.width;
            $$4 += this.animatedTexture.getFrameY(p_250374_) * this.height;
        }
        return ARGB.alpha(this.originalImage.getPixel($$3, $$4)) == 0;
    }

    public void uploadFirstFrame(int p_252315_, int p_248634_, GpuTexture p_404810_) {
        if (this.animatedTexture != null) {
            this.animatedTexture.uploadFirstFrame(p_252315_, p_248634_, p_404810_);
        } else {
            this.upload(p_252315_, p_248634_, 0, 0, this.byMipLevel, p_404810_);
        }
    }

    private static /* synthetic */ boolean lambda$createAnimatedTexture$4(IntSet p_251708_, int p_251185_) {
        return !p_251708_.contains(p_251185_);
    }

    class AnimatedTexture {
        final List<FrameInfo> frames;
        private final int frameRowSize;
        private final boolean interpolateFrames;

        AnimatedTexture(List<FrameInfo> p_250968_, int p_251686_, boolean p_251832_) {
            this.frames = p_250968_;
            this.frameRowSize = p_251686_;
            this.interpolateFrames = p_251832_;
        }

        int getFrameX(int p_249475_) {
            return p_249475_ % this.frameRowSize;
        }

        int getFrameY(int p_251327_) {
            return p_251327_ / this.frameRowSize;
        }

        void uploadFrame(int p_250449_, int p_248877_, int p_249060_, GpuTexture p_404869_) {
            int $$4 = this.getFrameX(p_249060_) * SpriteContents.this.width;
            int $$5 = this.getFrameY(p_249060_) * SpriteContents.this.height;
            SpriteContents.this.upload(p_250449_, p_248877_, $$4, $$5, SpriteContents.this.byMipLevel, p_404869_);
        }

        public SpriteTicker createTicker() {
            return new Ticker(SpriteContents.this, this, this.interpolateFrames ? new InterpolationData() : null);
        }

        public void uploadFirstFrame(int p_251807_, int p_248676_, GpuTexture p_405131_) {
            this.uploadFrame(p_251807_, p_248676_, this.frames.get((int)0).index, p_405131_);
        }

        public IntStream getUniqueFrames() {
            return this.frames.stream().mapToInt(p_249981_ -> p_249981_.index).distinct();
        }
    }

    record FrameInfo(int index, int time) {
    }

    class Ticker
    implements SpriteTicker {
        int frame;
        int subFrame;
        final AnimatedTexture animationInfo;
        @Nullable
        private final InterpolationData interpolationData;

        Ticker(SpriteContents spriteContents, @Nullable AnimatedTexture p_249618_, InterpolationData p_251097_) {
            this.animationInfo = p_249618_;
            this.interpolationData = p_251097_;
        }

        @Override
        public void tickAndUpload(int p_249105_, int p_249676_, GpuTexture p_404744_) {
            ++this.subFrame;
            FrameInfo $$3 = this.animationInfo.frames.get(this.frame);
            if (this.subFrame >= $$3.time) {
                int $$4 = $$3.index;
                this.frame = (this.frame + 1) % this.animationInfo.frames.size();
                this.subFrame = 0;
                int $$5 = this.animationInfo.frames.get((int)this.frame).index;
                if ($$4 != $$5) {
                    this.animationInfo.uploadFrame(p_249105_, p_249676_, $$5, p_404744_);
                }
            } else if (this.interpolationData != null) {
                this.interpolationData.uploadInterpolatedFrame(p_249105_, p_249676_, this, p_404744_);
            }
        }

        @Override
        public void close() {
            if (this.interpolationData != null) {
                this.interpolationData.close();
            }
        }
    }

    final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] activeFrame;

        InterpolationData() {
            this.activeFrame = new NativeImage[SpriteContents.this.byMipLevel.length];
            for (int $$0 = 0; $$0 < this.activeFrame.length; ++$$0) {
                int $$1 = SpriteContents.this.width >> $$0;
                int $$2 = SpriteContents.this.height >> $$0;
                this.activeFrame[$$0] = new NativeImage($$1, $$2, false);
            }
        }

        void uploadInterpolatedFrame(int p_250513_, int p_251644_, Ticker p_248626_, GpuTexture p_405042_) {
            AnimatedTexture $$4 = p_248626_.animationInfo;
            List<FrameInfo> $$5 = $$4.frames;
            FrameInfo $$6 = $$5.get(p_248626_.frame);
            float $$7 = (float)p_248626_.subFrame / (float)$$6.time;
            int $$8 = $$6.index;
            int $$9 = $$5.get((int)((p_248626_.frame + 1) % $$5.size())).index;
            if ($$8 != $$9) {
                for (int $$10 = 0; $$10 < this.activeFrame.length; ++$$10) {
                    int $$11 = SpriteContents.this.width >> $$10;
                    int $$12 = SpriteContents.this.height >> $$10;
                    for (int $$13 = 0; $$13 < $$12; ++$$13) {
                        for (int $$14 = 0; $$14 < $$11; ++$$14) {
                            int $$15 = this.getPixel($$4, $$8, $$10, $$14, $$13);
                            int $$16 = this.getPixel($$4, $$9, $$10, $$14, $$13);
                            this.activeFrame[$$10].setPixel($$14, $$13, ARGB.lerp($$7, $$15, $$16));
                        }
                    }
                }
                SpriteContents.this.upload(p_250513_, p_251644_, 0, 0, this.activeFrame, p_405042_);
            }
        }

        private int getPixel(AnimatedTexture p_251976_, int p_250761_, int p_250049_, int p_250004_, int p_251489_) {
            return SpriteContents.this.byMipLevel[p_250049_].getPixel(p_250004_ + (p_251976_.getFrameX(p_250761_) * SpriteContents.this.width >> p_250049_), p_251489_ + (p_251976_.getFrameY(p_250761_) * SpriteContents.this.height >> p_250049_));
        }

        @Override
        public void close() {
            for (NativeImage $$0 : this.activeFrame) {
                $$0.close();
            }
        }
    }
}

