/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ARGB;

public class OverlayTexture
implements AutoCloseable {
    private static final int SIZE = 16;
    public static final int NO_WHITE_U = 0;
    public static final int RED_OVERLAY_V = 3;
    public static final int WHITE_OVERLAY_V = 10;
    public static final int NO_OVERLAY = OverlayTexture.pack(0, 10);
    private final DynamicTexture texture = new DynamicTexture("Entity Color Overlay", 16, 16, false);

    public OverlayTexture() {
        NativeImage $$0 = this.texture.getPixels();
        for (int $$1 = 0; $$1 < 16; ++$$1) {
            for (int $$2 = 0; $$2 < 16; ++$$2) {
                if ($$1 < 8) {
                    $$0.setPixel($$2, $$1, -1291911168);
                    continue;
                }
                int $$3 = (int)((1.0f - (float)$$2 / 15.0f * 0.75f) * 255.0f);
                $$0.setPixel($$2, $$1, ARGB.color($$3, -1));
            }
        }
        this.texture.setClamp(true);
        this.texture.upload();
    }

    @Override
    public void close() {
        this.texture.close();
    }

    public void setupOverlayColor() {
        RenderSystem.setupOverlayColor(this.texture.getTextureView());
    }

    public static int u(float p_118089_) {
        return (int)(p_118089_ * 15.0f);
    }

    public static int v(boolean p_118097_) {
        return p_118097_ ? 3 : 10;
    }

    public static int pack(int p_118094_, int p_118095_) {
        return p_118094_ | p_118095_ << 16;
    }

    public static int pack(float p_118091_, boolean p_118092_) {
        return OverlayTexture.pack(OverlayTexture.u(p_118091_), OverlayTexture.v(p_118092_));
    }

    public void teardownOverlayColor() {
        RenderSystem.teardownOverlayColor();
    }
}

