/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.SkullBlock;
import org.joml.Vector3f;

public class SkullSpecialRenderer
implements NoDataSpecialModelRenderer {
    private final SkullModelBase model;
    private final float animation;
    private final RenderType renderType;

    public SkullSpecialRenderer(SkullModelBase p_386930_, float p_390424_, RenderType p_428553_) {
        this.model = p_386930_;
        this.animation = p_390424_;
        this.renderType = p_428553_;
    }

    @Override
    public void render(ItemDisplayContext p_387716_, PoseStack p_386490_, MultiBufferSource p_388080_, int p_387930_, int p_387838_, boolean p_386959_) {
        SkullBlockRenderer.renderSkull(null, 180.0f, this.animation, p_386490_, p_388080_, p_387930_, this.model, this.renderType);
    }

    @Override
    public void getExtents(Set<Vector3f> p_428193_) {
        PoseStack $$1 = new PoseStack();
        $$1.translate(0.5f, 0.0f, 0.5f);
        $$1.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(this.animation, 180.0f, 0.0f);
        this.model.root().getExtentsForGui($$1, p_428193_);
    }

    public record Unbaked(SkullBlock.Type kind, Optional<ResourceLocation> textureOverride, float animation) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_390096_ -> p_390096_.group((App)SkullBlock.Type.CODEC.fieldOf("kind").forGetter(Unbaked::kind), (App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(Unbaked::textureOverride), (App)Codec.FLOAT.optionalFieldOf("animation", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::animation)).apply((Applicative)p_390096_, Unbaked::new));

        public Unbaked(SkullBlock.Type p_387200_) {
            this(p_387200_, Optional.empty(), 0.0f);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet p_388555_) {
            SkullModelBase $$1 = SkullBlockRenderer.createModel(p_388555_, this.kind);
            ResourceLocation $$2 = this.textureOverride.map(p_389346_ -> p_389346_.withPath(p_389344_ -> "textures/entity/" + p_389344_ + ".png")).orElse(null);
            if ($$1 == null) {
                return null;
            }
            RenderType $$3 = SkullBlockRenderer.getSkullRenderType(this.kind, $$2);
            return new SkullSpecialRenderer($$1, this.animation, $$3);
        }
    }
}

