/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.joml.Vector3f;

public class ShieldSpecialRenderer
implements SpecialModelRenderer<DataComponentMap> {
    private final ShieldModel model;

    public ShieldSpecialRenderer(ShieldModel p_386724_) {
        this.model = p_386724_;
    }

    @Override
    @Nullable
    public DataComponentMap extractArgument(ItemStack p_387204_) {
        return p_387204_.immutableComponents();
    }

    @Override
    public void render(@Nullable DataComponentMap p_386991_, ItemDisplayContext p_388730_, PoseStack p_387961_, MultiBufferSource p_388686_, int p_387382_, int p_387013_, boolean p_387902_) {
        BannerPatternLayers $$7 = p_386991_ != null ? p_386991_.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor $$8 = p_386991_ != null ? p_386991_.get(DataComponents.BASE_COLOR) : null;
        boolean $$9 = !$$7.layers().isEmpty() || $$8 != null;
        p_387961_.pushPose();
        p_387961_.scale(1.0f, -1.0f, -1.0f);
        Material $$10 = $$9 ? ModelBakery.SHIELD_BASE : ModelBakery.NO_PATTERN_SHIELD;
        VertexConsumer $$11 = $$10.sprite().wrap(ItemRenderer.getFoilBuffer(p_388686_, this.model.renderType($$10.atlasLocation()), p_388730_ == ItemDisplayContext.GUI, p_387902_));
        this.model.handle().render(p_387961_, $$11, p_387382_, p_387013_);
        if ($$9) {
            BannerRenderer.renderPatterns(p_387961_, p_388686_, p_387382_, p_387013_, this.model.plate(), $$10, false, Objects.requireNonNullElse($$8, DyeColor.WHITE), $$7, p_387902_, false);
        } else {
            this.model.plate().render(p_387961_, $$11, p_387382_, p_387013_);
        }
        p_387961_.popPose();
    }

    @Override
    public void getExtents(Set<Vector3f> p_428407_) {
        PoseStack $$1 = new PoseStack();
        $$1.scale(1.0f, -1.0f, -1.0f);
        this.model.root().getExtentsForGui($$1, p_428407_);
    }

    @Override
    @Nullable
    public /* synthetic */ Object extractArgument(ItemStack itemStack) {
        return this.extractArgument(itemStack);
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Override
        public SpecialModelRenderer<?> bake(EntityModelSet p_387269_) {
            return new ShieldSpecialRenderer(new ShieldModel(p_387269_.bakeLayer(ModelLayers.SHIELD)));
        }
    }
}

