/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemStackRenderState {
    ItemDisplayContext displayContext = ItemDisplayContext.NONE;
    private int activeLayerCount;
    private boolean animated;
    private boolean oversizedInGui;
    @Nullable
    private AABB cachedModelBoundingBox;
    private LayerRenderState[] layers = new LayerRenderState[]{new LayerRenderState()};

    public void ensureCapacity(int p_387339_) {
        int $$2 = this.activeLayerCount + p_387339_;
        int $$1 = this.layers.length;
        if ($$2 > $$1) {
            this.layers = Arrays.copyOf(this.layers, $$2);
            for (int $$3 = $$1; $$3 < $$2; ++$$3) {
                this.layers[$$3] = new LayerRenderState();
            }
        }
    }

    public LayerRenderState newLayer() {
        this.ensureCapacity(1);
        return this.layers[this.activeLayerCount++];
    }

    public void clear() {
        this.displayContext = ItemDisplayContext.NONE;
        for (int $$0 = 0; $$0 < this.activeLayerCount; ++$$0) {
            this.layers[$$0].clear();
        }
        this.activeLayerCount = 0;
        this.animated = false;
        this.oversizedInGui = false;
        this.cachedModelBoundingBox = null;
    }

    public void setAnimated() {
        this.animated = true;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void appendModelIdentityElement(Object p_416649_) {
    }

    private LayerRenderState firstLayer() {
        return this.layers[0];
    }

    public boolean isEmpty() {
        return this.activeLayerCount == 0;
    }

    public boolean usesBlockLight() {
        return this.firstLayer().usesBlockLight;
    }

    @Nullable
    public TextureAtlasSprite pickParticleIcon(RandomSource p_387539_) {
        if (this.activeLayerCount == 0) {
            return null;
        }
        return this.layers[p_387539_.nextInt((int)this.activeLayerCount)].particleIcon;
    }

    public void visitExtents(Consumer<Vector3fc> p_405345_) {
        Vector3f $$1 = new Vector3f();
        PoseStack.Pose $$2 = new PoseStack.Pose();
        for (int $$3 = 0; $$3 < this.activeLayerCount; ++$$3) {
            Vector3f[] $$6;
            LayerRenderState $$4 = this.layers[$$3];
            $$4.transform.apply(this.displayContext.leftHand(), $$2);
            Matrix4f $$5 = $$2.pose();
            for (Vector3f $$7 : $$6 = $$4.extents.get()) {
                p_405345_.accept((Vector3fc)$$1.set((Vector3fc)$$7).mulPosition((Matrix4fc)$$5));
            }
            $$2.setIdentity();
        }
    }

    public void render(PoseStack p_388193_, MultiBufferSource p_388719_, int p_386913_, int p_387272_) {
        for (int $$4 = 0; $$4 < this.activeLayerCount; ++$$4) {
            this.layers[$$4].render(p_388193_, p_388719_, p_386913_, p_387272_);
        }
    }

    public AABB getModelBoundingBox() {
        AABB $$1;
        if (this.cachedModelBoundingBox != null) {
            return this.cachedModelBoundingBox;
        }
        AABB.Builder $$0 = new AABB.Builder();
        this.visitExtents($$0::include);
        this.cachedModelBoundingBox = $$1 = $$0.build();
        return $$1;
    }

    public void setOversizedInGui(boolean p_428189_) {
        this.oversizedInGui = p_428189_;
    }

    public boolean isOversizedInGui() {
        return this.oversizedInGui;
    }

    public class LayerRenderState {
        private static final Vector3f[] NO_EXTENTS = new Vector3f[0];
        public static final Supplier<Vector3f[]> NO_EXTENTS_SUPPLIER = () -> NO_EXTENTS;
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
        boolean usesBlockLight;
        @Nullable
        TextureAtlasSprite particleIcon;
        ItemTransform transform = ItemTransform.NO_TRANSFORM;
        @Nullable
        private RenderType renderType;
        private FoilType foilType = FoilType.NONE;
        private int[] tintLayers = new int[0];
        @Nullable
        private SpecialModelRenderer<Object> specialRenderer;
        @Nullable
        private Object argumentForSpecialRendering;
        Supplier<Vector3f[]> extents = NO_EXTENTS_SUPPLIER;

        public void clear() {
            this.quads.clear();
            this.renderType = null;
            this.foilType = FoilType.NONE;
            this.specialRenderer = null;
            this.argumentForSpecialRendering = null;
            Arrays.fill(this.tintLayers, -1);
            this.usesBlockLight = false;
            this.particleIcon = null;
            this.transform = ItemTransform.NO_TRANSFORM;
            this.extents = NO_EXTENTS_SUPPLIER;
        }

        public List<BakedQuad> prepareQuadList() {
            return this.quads;
        }

        public void setRenderType(RenderType p_405446_) {
            this.renderType = p_405446_;
        }

        public void setUsesBlockLight(boolean p_405321_) {
            this.usesBlockLight = p_405321_;
        }

        public void setExtents(Supplier<Vector3f[]> p_405802_) {
            this.extents = p_405802_;
        }

        public void setParticleIcon(TextureAtlasSprite p_404929_) {
            this.particleIcon = p_404929_;
        }

        public void setTransform(ItemTransform p_404949_) {
            this.transform = p_404949_;
        }

        public <T> void setupSpecialModel(SpecialModelRenderer<T> p_386884_, @Nullable T p_388093_) {
            this.specialRenderer = LayerRenderState.eraseSpecialRenderer(p_386884_);
            this.argumentForSpecialRendering = p_388093_;
        }

        private static SpecialModelRenderer<Object> eraseSpecialRenderer(SpecialModelRenderer<?> p_388852_) {
            return p_388852_;
        }

        public void setFoilType(FoilType p_386511_) {
            this.foilType = p_386511_;
        }

        public int[] prepareTintLayers(int p_387793_) {
            if (p_387793_ > this.tintLayers.length) {
                this.tintLayers = new int[p_387793_];
                Arrays.fill(this.tintLayers, -1);
            }
            return this.tintLayers;
        }

        void render(PoseStack p_387607_, MultiBufferSource p_386763_, int p_387589_, int p_388775_) {
            p_387607_.pushPose();
            this.transform.apply(ItemStackRenderState.this.displayContext.leftHand(), p_387607_.last());
            if (this.specialRenderer != null) {
                this.specialRenderer.render(this.argumentForSpecialRendering, ItemStackRenderState.this.displayContext, p_387607_, p_386763_, p_387589_, p_388775_, this.foilType != FoilType.NONE);
            } else if (this.renderType != null) {
                ItemRenderer.renderItem(ItemStackRenderState.this.displayContext, p_387607_, p_386763_, p_387589_, p_388775_, this.tintLayers, this.quads, this.renderType, this.foilType);
            }
            p_387607_.popPose();
        }
    }

    public static enum FoilType {
        NONE,
        STANDARD,
        SPECIAL;

    }
}

